/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform;
import java.util.Arrays;

public class KaldiDiscreteCosineTransform
extends DiscreteCosineTransform {
    public KaldiDiscreteCosineTransform(int numberMelFilters, int cepstrumSize) {
        super(numberMelFilters, cepstrumSize);
    }

    public KaldiDiscreteCosineTransform() {
    }

    @Override
    protected void computeMelCosine() {
        this.melcosine = new double[this.cepstrumSize][this.numberMelFilters];
        Arrays.fill(this.melcosine[0], Math.sqrt(1.0 / (double)this.numberMelFilters));
        double normScale = Math.sqrt(2.0 / (double)this.numberMelFilters);
        for (int i = 1; i < this.cepstrumSize; ++i) {
            double frequency = Math.PI * (double)i / (double)this.numberMelFilters;
            for (int j = 0; j < this.numberMelFilters; ++j) {
                this.melcosine[i][j] = normScale * Math.cos(frequency * ((double)j + 0.5));
            }
        }
    }

    @Override
    protected double[] applyMelCosine(double[] melspectrum) {
        double[] cepstrum = new double[this.cepstrumSize];
        for (int i = 0; i < cepstrum.length; ++i) {
            for (int j = 0; j < this.numberMelFilters; ++j) {
                int n = i;
                cepstrum[n] = cepstrum[n] + melspectrum[j] * this.melcosine[i][j];
            }
        }
        return cepstrum;
    }
}

