/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.filter;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.Random;

public class Dither
extends BaseDataProcessor {
    @S4Double(defaultValue=2.0)
    public static final String PROP_MAX_DITHER = "maxDither";
    private double ditherMax;
    @S4Double(defaultValue=1.7976931348623157E308)
    public static final String PROP_MAX_VAL = "upperValueBound";
    private double maxValue;
    @S4Double(defaultValue=-1.7976931348623157E308)
    public static final String PROP_MIN_VAL = "lowerValueBound";
    private double minValue;
    @S4Boolean(defaultValue=false)
    public static final String PROP_USE_RANDSEED = "useRandSeed";
    private boolean useRandSeed;
    Random r;

    public Dither(double ditherMax, boolean useRandSeed, double maxValue, double minValue) {
        this.initLogger();
        this.ditherMax = ditherMax;
        this.useRandSeed = useRandSeed;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.initialize();
    }

    public Dither() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.ditherMax = ps.getDouble(PROP_MAX_DITHER);
        this.useRandSeed = ps.getBoolean(PROP_USE_RANDSEED);
        this.maxValue = ps.getDouble(PROP_MAX_VAL);
        this.minValue = ps.getDouble(PROP_MIN_VAL);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.r = this.useRandSeed ? new Random() : new Random(12345L);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (input != null && this.ditherMax != 0.0 && (input instanceof DoubleData || input instanceof FloatData)) {
            input = this.process(input);
        }
        return input;
    }

    private DoubleData process(Data input) throws IllegalArgumentException {
        assert (input instanceof DoubleData);
        DoubleData doubleData = (DoubleData)input;
        double[] inFeatures = doubleData.getValues();
        double[] outFeatures = new double[inFeatures.length];
        for (int i = 0; i < inFeatures.length; ++i) {
            outFeatures[i] = (double)(this.r.nextFloat() * 2.0f) * this.ditherMax - this.ditherMax + inFeatures[i];
            outFeatures[i] = Math.max(Math.min(outFeatures[i], this.maxValue), this.minValue);
        }
        DoubleData output = new DoubleData(outFeatures, doubleData.getSampleRate(), doubleData.getFirstSampleNumber());
        return output;
    }
}

