/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.feature.AbstractFeatureExtractor;

public class KaldiDeltasFeatureExtractor
extends AbstractFeatureExtractor {
    public KaldiDeltasFeatureExtractor(int window) {
        super(window);
    }

    public KaldiDeltasFeatureExtractor() {
    }

    @Override
    protected Data computeNextFeature() {
        int k;
        int jp1 = (this.currentPosition - 1 + this.cepstraBufferSize) % this.cepstraBufferSize;
        int jp2 = (this.currentPosition - 2 + this.cepstraBufferSize) % this.cepstraBufferSize;
        int jp3 = (this.currentPosition - 3 + this.cepstraBufferSize) % this.cepstraBufferSize;
        int jp4 = (this.currentPosition - 4 + this.cepstraBufferSize) % this.cepstraBufferSize;
        int jf1 = (this.currentPosition + 1) % this.cepstraBufferSize;
        int jf2 = (this.currentPosition + 2) % this.cepstraBufferSize;
        int jf3 = (this.currentPosition + 3) % this.cepstraBufferSize;
        int jf4 = (this.currentPosition + 4) % this.cepstraBufferSize;
        DoubleData currentCepstrum = this.cepstraBuffer[this.currentPosition];
        double[] mfc4f = this.cepstraBuffer[jf4].getValues();
        double[] mfc3f = this.cepstraBuffer[jf3].getValues();
        double[] mfc2f = this.cepstraBuffer[jf2].getValues();
        double[] mfc1f = this.cepstraBuffer[jf1].getValues();
        double[] current = currentCepstrum.getValues();
        double[] mfc1p = this.cepstraBuffer[jp1].getValues();
        double[] mfc2p = this.cepstraBuffer[jp2].getValues();
        double[] mfc3p = this.cepstraBuffer[jp3].getValues();
        double[] mfc4p = this.cepstraBuffer[jp4].getValues();
        float[] feature = new float[current.length * 3];
        this.currentPosition = (this.currentPosition + 1) % this.cepstraBufferSize;
        int j = 0;
        for (double val : current) {
            feature[j++] = (float)val;
        }
        for (k = 0; k < mfc2f.length; ++k) {
            feature[j++] = (float)(2.0 * mfc2f[k] + mfc1f[k] - mfc1p[k] - 2.0 * mfc2p[k]) / 10.0f;
        }
        for (k = 0; k < mfc3f.length; ++k) {
            feature[j++] = (float)(4.0 * mfc4f[k] + 4.0 * mfc3f[k] + mfc2f[k] - 4.0 * mfc1f[k] - 10.0 * current[k] + (4.0 * mfc4p[k] + 4.0 * mfc3p[k] + mfc2p[k] - 4.0 * mfc1p[k])) / 100.0f;
        }
        return new FloatData(feature, currentCepstrum.getSampleRate(), currentCepstrum.getFirstSampleNumber());
    }
}

