/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;
import java.util.LinkedList;

public abstract class AbstractFeatureExtractor
extends BaseDataProcessor {
    @S4Integer(defaultValue=3)
    public static final String PROP_FEATURE_WINDOW = "windowSize";
    private int bufferPosition;
    private Signal pendingSignal;
    private LinkedList<Data> outputQueue;
    protected int cepstraBufferEdge;
    protected int window;
    protected int currentPosition;
    protected int cepstraBufferSize;
    protected DoubleData[] cepstraBuffer;

    public AbstractFeatureExtractor(int window) {
        this.initLogger();
        this.window = window;
    }

    public AbstractFeatureExtractor() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.window = ps.getInt(PROP_FEATURE_WINDOW);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.cepstraBufferSize = 256;
        this.cepstraBuffer = new DoubleData[this.cepstraBufferSize];
        this.cepstraBufferEdge = this.cepstraBufferSize - (this.window * 2 + 2);
        this.outputQueue = new LinkedList();
        this.reset();
    }

    private void reset() {
        this.bufferPosition = 0;
        this.currentPosition = 0;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input;
        if (this.outputQueue.isEmpty() && (input = this.getNextData()) != null) {
            if (input instanceof DoubleData) {
                this.addCepstrum((DoubleData)input);
                this.computeFeatures(1);
            } else if (input instanceof DataStartSignal) {
                this.pendingSignal = null;
                this.outputQueue.add(input);
                Data start = this.getNextData();
                int n = this.processFirstCepstrum(start);
                this.computeFeatures(n);
                if (this.pendingSignal != null) {
                    this.outputQueue.add(this.pendingSignal);
                }
            } else if (input instanceof SpeechEndSignal) {
                int n = this.replicateLastCepstrum();
                this.computeFeatures(n);
                this.outputQueue.add(input);
            } else if (input instanceof DataEndSignal) {
                this.outputQueue.add(input);
            }
        }
        return this.outputQueue.isEmpty() ? null : this.outputQueue.removeFirst();
    }

    private Data getNextData() throws DataProcessingException {
        Data d = this.getPredecessor().getData();
        while (!(d == null || d instanceof DoubleData || d instanceof DataEndSignal || d instanceof DataStartSignal || d instanceof SpeechEndSignal)) {
            this.outputQueue.add(d);
            d = this.getPredecessor().getData();
        }
        return d;
    }

    private int processFirstCepstrum(Data cepstrum) throws DataProcessingException {
        if (cepstrum instanceof DataEndSignal) {
            this.outputQueue.add(cepstrum);
            return 0;
        }
        if (cepstrum instanceof DataStartSignal) {
            throw new Error("Too many UTTERANCE_START");
        }
        Arrays.fill(this.cepstraBuffer, 0, this.window + 1, cepstrum);
        this.bufferPosition = this.window + 1;
        this.bufferPosition %= this.cepstraBufferSize;
        this.currentPosition = this.window;
        this.currentPosition %= this.cepstraBufferSize;
        int numberFeatures = 1;
        this.pendingSignal = null;
        for (int i = 0; i < this.window; ++i) {
            Data next = this.getNextData();
            if (next == null) continue;
            if (next instanceof DoubleData) {
                this.addCepstrum((DoubleData)next);
                continue;
            }
            if (next instanceof DataEndSignal || next instanceof SpeechEndSignal) {
                this.pendingSignal = (Signal)next;
                this.replicateLastCepstrum();
                numberFeatures += i;
                break;
            }
            if (!(next instanceof DataStartSignal)) continue;
            throw new Error("Too many UTTERANCE_START");
        }
        return numberFeatures;
    }

    private void addCepstrum(DoubleData cepstrum) {
        this.cepstraBuffer[this.bufferPosition++] = cepstrum;
        this.bufferPosition %= this.cepstraBufferSize;
    }

    private int replicateLastCepstrum() {
        DoubleData last;
        if (this.bufferPosition > 0) {
            last = this.cepstraBuffer[this.bufferPosition - 1];
        } else if (this.bufferPosition == 0) {
            last = this.cepstraBuffer[this.cepstraBuffer.length - 1];
        } else {
            throw new Error("BufferPosition < 0");
        }
        for (int i = 0; i < this.window; ++i) {
            this.addCepstrum(last);
        }
        return this.window;
    }

    private void computeFeatures(int totalFeatures) {
        if (totalFeatures == 1) {
            this.computeFeature();
        } else {
            for (int i = 0; i < totalFeatures; ++i) {
                this.computeFeature();
            }
        }
    }

    private void computeFeature() {
        Data feature = this.computeNextFeature();
        this.outputQueue.add(feature);
    }

    protected abstract Data computeNextFeature();
}

