/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.denoise;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;

public class Denoise
extends BaseDataProcessor {
    double[] power;
    double[] noise;
    double[] floor;
    double[] peak;
    @S4Double(defaultValue=0.7)
    public static final String LAMBDA_POWER = "lambdaPower";
    double lambdaPower;
    @S4Double(defaultValue=0.995)
    public static final String LAMBDA_A = "lambdaA";
    double lambdaA;
    @S4Double(defaultValue=0.5)
    public static final String LAMBDA_B = "lambdaB";
    double lambdaB;
    @S4Double(defaultValue=0.85)
    public static final String LAMBDA_T = "lambdaT";
    double lambdaT;
    @S4Double(defaultValue=0.2)
    public static final String MU_T = "muT";
    double muT;
    @S4Double(defaultValue=20.0)
    public static final String MAX_GAIN = "maxGain";
    double maxGain;
    @S4Integer(defaultValue=4)
    public static final String SMOOTH_WINDOW = "smoothWindow";
    int smoothWindow;
    static final double EPS = 1.0E-10;

    public Denoise(double lambdaPower, double lambdaA, double lambdaB, double lambdaT, double muT, double maxGain, int smoothWindow) {
        this.lambdaPower = lambdaPower;
        this.lambdaA = lambdaA;
        this.lambdaB = lambdaB;
        this.lambdaT = lambdaT;
        this.muT = muT;
        this.maxGain = maxGain;
        this.smoothWindow = smoothWindow;
    }

    public Denoise() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.lambdaPower = ps.getDouble(LAMBDA_POWER);
        this.lambdaA = ps.getDouble(LAMBDA_A);
        this.lambdaB = ps.getDouble(LAMBDA_B);
        this.lambdaT = ps.getDouble(LAMBDA_T);
        this.muT = ps.getDouble(MU_T);
        this.maxGain = ps.getDouble(MAX_GAIN);
        this.smoothWindow = ps.getInt(SMOOTH_WINDOW);
    }

    @Override
    public Data getData() throws DataProcessingException {
        int i;
        Data inputData = this.getPredecessor().getData();
        if (inputData instanceof DataStartSignal) {
            this.power = null;
            this.noise = null;
            this.floor = null;
            this.peak = null;
            return inputData;
        }
        if (!(inputData instanceof DoubleData)) {
            return inputData;
        }
        DoubleData inputDoubleData = (DoubleData)inputData;
        double[] input = inputDoubleData.getValues();
        int length = input.length;
        if (this.power == null) {
            this.initStatistics(input, length);
        }
        this.updatePower(input);
        this.estimateEnvelope(this.power, this.noise);
        double[] signal = new double[length];
        for (i = 0; i < length; ++i) {
            signal[i] = Math.max(this.power[i] - this.noise[i], 0.0);
        }
        this.estimateEnvelope(signal, this.floor);
        this.tempMasking(signal);
        this.powerBoosting(signal);
        double[] gain = new double[length];
        for (i = 0; i < length; ++i) {
            gain[i] = signal[i] / (this.power[i] + 1.0E-10);
            gain[i] = Math.min(Math.max(gain[i], 1.0 / this.maxGain), this.maxGain);
        }
        double[] smoothGain = this.smooth(gain);
        for (i = 0; i < length; ++i) {
            int n = i;
            input[n] = input[n] * smoothGain[i];
        }
        return inputData;
    }

    private double[] smooth(double[] gain) {
        double[] result = new double[gain.length];
        for (int i = 0; i < gain.length; ++i) {
            int start = Math.max(i - this.smoothWindow, 0);
            int end = Math.min(i + this.smoothWindow + 1, gain.length);
            double sum = 0.0;
            for (int j = start; j < end; ++j) {
                sum += gain[j];
            }
            result[i] = sum / (double)(end - start);
        }
        return result;
    }

    private void powerBoosting(double[] signal) {
        for (int i = 0; i < signal.length; ++i) {
            if (!(signal[i] < this.floor[i])) continue;
            signal[i] = this.floor[i];
        }
    }

    private void tempMasking(double[] signal) {
        for (int i = 0; i < signal.length; ++i) {
            double in = signal[i];
            int n = i;
            this.peak[n] = this.peak[n] * this.lambdaT;
            if (signal[i] < this.lambdaT * this.peak[i]) {
                signal[i] = this.peak[i] * this.muT;
            }
            if (!(in > this.peak[i])) continue;
            this.peak[i] = in;
        }
    }

    private void updatePower(double[] input) {
        for (int i = 0; i < input.length; ++i) {
            this.power[i] = this.lambdaPower * this.power[i] + (1.0 - this.lambdaPower) * input[i];
        }
    }

    private void estimateEnvelope(double[] signal, double[] envelope) {
        for (int i = 0; i < signal.length; ++i) {
            envelope[i] = signal[i] > envelope[i] ? this.lambdaA * envelope[i] + (1.0 - this.lambdaA) * signal[i] : this.lambdaB * envelope[i] + (1.0 - this.lambdaB) * signal[i];
        }
    }

    private void initStatistics(double[] input, int length) {
        this.power = Arrays.copyOf(input, length);
        this.noise = Arrays.copyOf(input, length);
        this.floor = new double[length];
        this.peak = new double[length];
        for (int i = 0; i < length; ++i) {
            this.floor[i] = input[i] / this.maxGain;
        }
    }
}

