/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;

public class GainControlProcessor
extends BaseDataProcessor {
    @S4Double(defaultValue=1.0)
    public static final String GAIN_FACTOR = "gainFactor";
    private double gainFactor;

    public GainControlProcessor(double gainFactor) {
        this.initLogger();
        this.gainFactor = gainFactor;
    }

    public GainControlProcessor() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.gainFactor = ps.getDouble(GAIN_FACTOR);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        block5: {
            block4: {
                data = this.getPredecessor().getData();
                if (!(data instanceof FloatData)) break block4;
                float[] values = ((FloatData)data).getValues();
                if (this.gainFactor == 1.0) break block5;
                int i = 0;
                while (i < values.length) {
                    int n = i++;
                    values[n] = (float)((double)values[n] * this.gainFactor);
                }
                break block5;
            }
            if (data instanceof DoubleData) {
                double[] values = ((DoubleData)data).getValues();
                if (this.gainFactor != 1.0) {
                    int i = 0;
                    while (i < values.length) {
                        int n = i++;
                        values[n] = values[n] * this.gainFactor;
                    }
                }
            }
        }
        return data;
    }

    public double getGainFactor() {
        return this.gainFactor;
    }

    public void setGainFactor(double gainFactor) {
        this.gainFactor = gainFactor;
    }
}

