/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.LinkedList;

public class DataBlocker
extends BaseDataProcessor {
    @S4Double(defaultValue=10.0)
    public static final String PROP_BLOCK_SIZE_MS = "blockSizeMs";
    private double blockSizeMs;
    private int blockSizeSamples = Integer.MAX_VALUE;
    private int curFirstSamplePos;
    private int sampleRate = -1;
    private final LinkedList<DoubleData> inBuffer = new LinkedList();
    private int curInBufferSize;

    public DataBlocker() {
    }

    public DataBlocker(double blockSizeMs) {
        this.initLogger();
        this.blockSizeMs = blockSizeMs;
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.blockSizeMs = propertySheet.getDouble(PROP_BLOCK_SIZE_MS);
    }

    public double getBlockSizeMs() {
        return this.blockSizeMs;
    }

    @Override
    public Data getData() throws DataProcessingException {
        while (this.curInBufferSize < this.blockSizeSamples || this.curInBufferSize == 0) {
            Data data = this.getPredecessor().getData();
            if (data instanceof DataStartSignal) {
                this.sampleRate = ((DataStartSignal)data).getSampleRate();
                this.blockSizeSamples = (int)Math.round((double)this.sampleRate * this.blockSizeMs / 1000.0);
                this.curInBufferSize = 0;
                this.curFirstSamplePos = 0;
                this.inBuffer.clear();
            }
            if (!(data instanceof DoubleData)) {
                return data;
            }
            DoubleData dd = (DoubleData)data;
            this.inBuffer.add(dd);
            this.curInBufferSize += dd.getValues().length;
        }
        double[] newSampleBlock = new double[this.blockSizeSamples];
        int copiedSamples = 0;
        long firstSample = this.inBuffer.get(0).getFirstSampleNumber() + (long)this.curFirstSamplePos;
        while (!this.inBuffer.isEmpty()) {
            DoubleData dd = this.inBuffer.remove(0);
            double[] values = dd.getValues();
            int copyLength = Math.min(this.blockSizeSamples - copiedSamples, values.length - this.curFirstSamplePos);
            System.arraycopy(values, this.curFirstSamplePos, newSampleBlock, copiedSamples, copyLength);
            if (copyLength < values.length - this.curFirstSamplePos) {
                assert (this.inBuffer.isEmpty());
                this.curFirstSamplePos += copyLength;
                this.inBuffer.add(0, dd);
                break;
            }
            copiedSamples += copyLength;
            this.curFirstSamplePos = 0;
        }
        this.curInBufferSize = this.inBuffer.isEmpty() ? 0 : this.inBuffer.get(0).getValues().length - this.curFirstSamplePos;
        return new DoubleData(newSampleBlock, this.sampleRate, firstSample);
    }
}

