/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search.stats;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.WordSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StateHistoryTracker {
    final Map<WordSequence, WordStats> statMap = new HashMap<WordSequence, WordStats>();
    final int frameNumber;
    int stateCount;
    int maxWordHistories;

    public StateHistoryTracker(int frameNumber) {
        this.frameNumber = frameNumber;
    }

    public void add(Token t) {
        ++this.stateCount;
        WordSequence ws = this.getWordSequence(t);
        WordStats stats = this.statMap.get(ws);
        if (stats == null) {
            stats = new WordStats(ws);
            this.statMap.put(ws, stats);
        }
        stats.update(t);
    }

    public void dump() {
        this.dumpSummary();
        ArrayList<WordStats> stats = new ArrayList<WordStats>(this.statMap.values());
        Collections.sort(stats, WordStats.COMPARATOR);
        for (WordStats stat : stats) {
            System.out.println("   " + stat);
        }
    }

    void dumpSummary() {
        System.out.println("Frame: " + this.frameNumber + " states: " + this.stateCount + " histories " + this.statMap.size());
    }

    private WordSequence getWordSequence(Token token) {
        return token.getSearchState().getWordHistory();
    }

    static class WordStats {
        public static final Comparator<WordStats> COMPARATOR = new Comparator<WordStats>(){

            @Override
            public int compare(WordStats ws1, WordStats ws2) {
                if (ws1.maxScore > ws2.maxScore) {
                    return -1;
                }
                if (ws1.maxScore == ws2.maxScore) {
                    return 0;
                }
                return 1;
            }
        };
        private int size = 0;
        private float maxScore = -3.4028235E38f;
        private float minScore = Float.MAX_VALUE;
        private final WordSequence ws;

        WordStats(WordSequence ws) {
            this.ws = ws;
        }

        void update(Token t) {
            ++this.size;
            if (t.getScore() > this.maxScore) {
                this.maxScore = t.getScore();
            }
            if (t.getScore() < this.minScore) {
                this.minScore = t.getScore();
            }
        }

        public String toString() {
            return "states:" + this.size + " max:" + this.maxScore + " min:" + this.minScore + ' ' + this.ws;
        }
    }
}

