/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WordActiveListFactory
extends ActiveListFactory {
    @S4Integer(defaultValue=0)
    public static final String PROP_MAX_PATHS_PER_WORD = "maxPathsPerWord";
    @S4Integer(defaultValue=1)
    public static final String PROP_MAX_FILLER_WORDS = "maxFillerWords";
    private int maxPathsPerWord;
    private int maxFiller;

    public WordActiveListFactory(int absoluteBeamWidth, double relativeBeamWidth, int maxPathsPerWord, int maxFiller) {
        super(absoluteBeamWidth, relativeBeamWidth);
        this.maxPathsPerWord = maxPathsPerWord;
        this.maxFiller = maxFiller;
    }

    public WordActiveListFactory() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.maxPathsPerWord = ps.getInt(PROP_MAX_PATHS_PER_WORD);
        this.maxFiller = ps.getInt(PROP_MAX_FILLER_WORDS);
    }

    @Override
    public ActiveList newInstance() {
        return new WordActiveList();
    }

    class WordActiveList
    implements ActiveList {
        private Token bestToken;
        private List<Token> tokenList = new LinkedList<Token>();

        WordActiveList() {
        }

        @Override
        public void add(Token token) {
            this.tokenList.add(token);
            if (this.bestToken == null || token.getScore() > this.bestToken.getScore()) {
                this.bestToken = token;
            }
        }

        public void replace(Token oldToken, Token newToken) {
            this.add(newToken);
            if (oldToken != null) {
                this.tokenList.remove(oldToken);
            }
        }

        @Override
        public ActiveList purge() {
            int fillerCount = 0;
            HashMap<Word, Integer> countMap = new HashMap<Word, Integer>();
            Collections.sort(this.tokenList, Scoreable.COMPARATOR);
            Iterator<Token> i = this.tokenList.iterator();
            while (i.hasNext()) {
                int c;
                Token token = i.next();
                WordSearchState wordState = (WordSearchState)token.getSearchState();
                Word word = wordState.getPronunciation().getWord();
                if (WordActiveListFactory.this.maxFiller > 0 && word.isFiller()) {
                    if (fillerCount < WordActiveListFactory.this.maxFiller) {
                        ++fillerCount;
                    } else {
                        i.remove();
                        continue;
                    }
                }
                if (WordActiveListFactory.this.maxPathsPerWord <= 0) continue;
                Integer count = (Integer)countMap.get(word);
                int n = c = count == null ? 0 : count;
                if (c < WordActiveListFactory.this.maxPathsPerWord - 1) {
                    countMap.put(word, c + 1);
                    continue;
                }
                i.remove();
            }
            if (this.tokenList.size() > WordActiveListFactory.this.absoluteBeamWidth) {
                this.tokenList = this.tokenList.subList(0, WordActiveListFactory.this.absoluteBeamWidth);
            }
            return this;
        }

        @Override
        public Iterator<Token> iterator() {
            return this.tokenList.iterator();
        }

        @Override
        public List<Token> getTokens() {
            return this.tokenList;
        }

        @Override
        public final int size() {
            return this.tokenList.size();
        }

        @Override
        public float getBeamThreshold() {
            return this.getBestScore() + WordActiveListFactory.this.logRelativeBeamWidth;
        }

        @Override
        public float getBestScore() {
            float bestScore = -3.4028235E38f;
            if (this.bestToken != null) {
                bestScore = this.bestToken.getScore();
            }
            return bestScore;
        }

        @Override
        public void setBestToken(Token token) {
            this.bestToken = token;
        }

        @Override
        public Token getBestToken() {
            return this.bestToken;
        }

        @Override
        public ActiveList newInstance() {
            return WordActiveListFactory.this.newInstance();
        }
    }
}

