/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlternateHypothesisManager {
    private final Map<Token, List<Token>> viterbiLoserMap = new HashMap<Token, List<Token>>();
    private final int maxEdges;

    public AlternateHypothesisManager(int maxEdges) {
        this.maxEdges = maxEdges;
    }

    public void addAlternatePredecessor(Token token, Token predecessor) {
        assert (predecessor != token.getPredecessor());
        List<Token> list = this.viterbiLoserMap.get(token);
        if (list == null) {
            list = new ArrayList<Token>();
            this.viterbiLoserMap.put(token, list);
        }
        list.add(predecessor);
    }

    public List<Token> getAlternatePredecessors(Token token) {
        return this.viterbiLoserMap.get(token);
    }

    public void purge() {
        int max = this.maxEdges - 1;
        for (Map.Entry<Token, List<Token>> entry : this.viterbiLoserMap.entrySet()) {
            List<Token> list = entry.getValue();
            Collections.sort(list, Scoreable.COMPARATOR);
            List<Token> newList = list.subList(0, list.size() > max ? max : list.size());
            this.viterbiLoserMap.put(entry.getKey(), newList);
        }
    }

    public boolean hasAlternatePredecessors(Token token) {
        return this.viterbiLoserMap.containsKey(token);
    }
}

