/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.scorer;

import edu.cmu.sphinx.decoder.scorer.ScoreNormalizer;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.SimpleBreadthFirstSearchManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.util.List;
import java.util.logging.Logger;

public class BackgroundModelNormalizer
implements ScoreNormalizer {
    @S4Component(type=SimpleBreadthFirstSearchManager.class, mandatory=false)
    public static final String ACTIVE_LIST_PROVIDER = "activeListProvider";
    private SimpleBreadthFirstSearchManager activeListProvider;
    private Logger logger;

    public BackgroundModelNormalizer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.activeListProvider = (SimpleBreadthFirstSearchManager)ps.getComponent(ACTIVE_LIST_PROVIDER);
        this.logger = ps.getLogger();
        this.logger.warning("no active list set.");
    }

    public BackgroundModelNormalizer(SimpleBreadthFirstSearchManager activeListProvider) {
        this.activeListProvider = activeListProvider;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.warning("no active list set.");
    }

    @Override
    public Scoreable normalize(List<? extends Scoreable> scoreableList, Scoreable bestToken) {
        if (this.activeListProvider == null) {
            return bestToken;
        }
        Token normToken = this.activeListProvider.getActiveList().getBestToken();
        float normScore = normToken.getScore();
        for (Scoreable scoreable : scoreableList) {
            if (!(scoreable instanceof Token)) continue;
            scoreable.normalizeScore(normScore);
        }
        return bestToken;
    }
}

