/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.adaptation;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class ClusteredDensityFileData {
    private int numberOfClusters;
    private int[] corespondingClass;

    public ClusteredDensityFileData(Loader loader, int numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        this.kMeansClustering(loader, 30);
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public int getClassIndex(int gaussian) {
        return this.corespondingClass[gaussian];
    }

    private float euclidianDistance(float[] a, float[] b) {
        double s = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double d = a[i] - b[i];
            s += d * d;
        }
        return (float)FastMath.sqrt(s);
    }

    private boolean isEqual(float[] a, float[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private void kMeansClustering(Loader loader, int maxIterations) {
        int index;
        int i;
        Pool<float[]> initialData = loader.getMeansPool();
        ArrayList<Object> oldCentroids = new ArrayList<Object>(this.numberOfClusters);
        ArrayList<float[]> centroids = new ArrayList<float[]>(this.numberOfClusters);
        int numberOfElements = initialData.size();
        int nrOfIterations = maxIterations;
        int[] count = new int[this.numberOfClusters];
        float[][][] array = new float[this.numberOfClusters][numberOfElements][];
        boolean converged = false;
        Random randomGenerator = new Random();
        for (i = 0; i < this.numberOfClusters; ++i) {
            index = randomGenerator.nextInt(numberOfElements);
            centroids.add(initialData.get(index));
            oldCentroids.add(initialData.get(index));
            count[i] = 0;
        }
        index = 0;
        while (!converged && nrOfIterations > 0) {
            int k;
            this.corespondingClass = new int[initialData.size()];
            array = new float[this.numberOfClusters][numberOfElements][];
            for (i = 0; i < this.numberOfClusters; ++i) {
                oldCentroids.set(i, centroids.get(i));
                count[i] = 0;
            }
            for (i = 0; i < initialData.size(); ++i) {
                float[] currentValue = initialData.get(i);
                double min = this.euclidianDistance((float[])oldCentroids.get(0), currentValue);
                index = 0;
                for (k = 1; k < this.numberOfClusters; ++k) {
                    double distance = this.euclidianDistance((float[])oldCentroids.get(k), currentValue);
                    if (!(distance < min)) continue;
                    min = distance;
                    index = k;
                }
                array[index][count[index]] = currentValue;
                this.corespondingClass[i] = index;
                int n = index;
                count[n] = count[n] + 1;
            }
            for (i = 0; i < this.numberOfClusters; ++i) {
                float[] centroid = new float[initialData.get(0).length];
                if (count[i] <= 0) continue;
                for (int j = 0; j < count[i]; ++j) {
                    for (int k2 = 0; k2 < initialData.get(0).length; ++k2) {
                        int n = k2;
                        centroid[n] = centroid[n] + array[i][j][k2];
                    }
                }
                k = 0;
                while (k < initialData.get(0).length) {
                    int n = k++;
                    centroid[n] = centroid[n] / (float)count[i];
                }
                centroids.set(i, centroid);
            }
            converged = true;
            for (i = 0; i < this.numberOfClusters; ++i) {
                converged = converged && this.isEqual((float[])centroids.get(i), (float[])oldCentroids.get(i));
            }
            --nrOfIterations;
        }
    }
}

