/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class Microphone {
    private final TargetDataLine line;
    private final InputStream inputStream;

    public Microphone(float sampleRate, int sampleSize, boolean signed, boolean bigEndian) {
        AudioFormat format = new AudioFormat(sampleRate, sampleSize, 1, signed, bigEndian);
        try {
            this.line = AudioSystem.getTargetDataLine(format);
            this.line.open();
        }
        catch (LineUnavailableException e) {
            throw new IllegalStateException(e);
        }
        this.inputStream = new AudioInputStream(this.line);
    }

    public void startRecording() {
        this.line.start();
    }

    public void stopRecording() {
        this.line.stop();
    }

    public InputStream getStream() {
        return this.inputStream;
    }
}

