/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.OpEnum;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathExtractor {
    private static final Logger LOGGER = Logger.getLogger(PathExtractor.class.getName());
    public static final String INTERPRET_PATHS_PROPERTY = "com.sun.speech.freetts.interpretCartPaths";
    public static final String LAZY_COMPILE_PROPERTY = "com.sun.speech.freetts.lazyCartCompile";
    private static final boolean INTERPRET_PATHS = System.getProperty("com.sun.speech.freetts.interpretCartPaths", "false").equals("true");
    private static final boolean LAZY_COMPILE = System.getProperty("com.sun.speech.freetts.lazyCartCompile", "true").equals("true");
    private String pathAndFeature;
    private String path;
    private String feature;
    private Object[] compiledPath;

    public PathExtractor(String pathAndFeature, boolean wantFeature) {
        this.pathAndFeature = pathAndFeature;
        if (INTERPRET_PATHS) {
            this.path = pathAndFeature;
            return;
        }
        if (wantFeature) {
            int lastDot = pathAndFeature.lastIndexOf(".");
            if (lastDot == -1) {
                this.feature = pathAndFeature;
                this.path = null;
            } else {
                this.feature = pathAndFeature.substring(lastDot + 1);
                this.path = pathAndFeature.substring(0, lastDot);
            }
        } else {
            this.path = pathAndFeature;
        }
        if (!LAZY_COMPILE) {
            this.compiledPath = this.compile(this.path);
        }
    }

    public Item findItem(Item item) {
        if (INTERPRET_PATHS) {
            return item.findItem(this.path);
        }
        if (this.compiledPath == null) {
            this.compiledPath = this.compile(this.path);
        }
        Item pitem = item;
        int i = 0;
        while (pitem != null && i < this.compiledPath.length) {
            OpEnum op;
            if ((op = (OpEnum)this.compiledPath[i++]) == OpEnum.NEXT) {
                pitem = pitem.getNext();
                continue;
            }
            if (op == OpEnum.PREV) {
                pitem = pitem.getPrevious();
                continue;
            }
            if (op == OpEnum.NEXT_NEXT) {
                if ((pitem = pitem.getNext()) == null) continue;
                pitem = pitem.getNext();
                continue;
            }
            if (op == OpEnum.PREV_PREV) {
                if ((pitem = pitem.getPrevious()) == null) continue;
                pitem = pitem.getPrevious();
                continue;
            }
            if (op == OpEnum.PARENT) {
                pitem = pitem.getParent();
                continue;
            }
            if (op == OpEnum.DAUGHTER) {
                pitem = pitem.getDaughter();
                continue;
            }
            if (op == OpEnum.LAST_DAUGHTER) {
                pitem = pitem.getLastDaughter();
                continue;
            }
            if (op == OpEnum.RELATION) {
                String relationName = (String)this.compiledPath[i++];
                pitem = pitem.getSharedContents().getItemRelation(relationName);
                continue;
            }
            System.out.println("findItem: bad feature " + op + " in " + this.path);
        }
        return pitem;
    }

    public Object findFeature(Item item) {
        if (INTERPRET_PATHS) {
            return item.findFeature(this.path);
        }
        Item pitem = this.findItem(item);
        Object results = null;
        if (pitem != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("findFeature: Item [" + pitem + "], feature '" + this.feature + "'");
            }
            results = pitem.getFeatures().getObject(this.feature);
        }
        Object object = results = results == null ? "0" : results;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("findFeature: ...results = '" + results + "'");
        }
        return results;
    }

    private Object[] compile(String path) {
        if (path == null) {
            return new Object[0];
        }
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer tok = new StringTokenizer(path, ":.");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            OpEnum op = OpEnum.getInstance(token);
            if (op == null) {
                throw new Error("Bad path compiled " + path);
            }
            list.add(op);
            if (op != OpEnum.RELATION) continue;
            list.add(tok.nextToken());
        }
        return list.toArray();
    }

    public String toString() {
        return this.pathAndFeature;
    }
}

