/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.ItemContents;
import edu.cmu.sphinx.alignment.tokenizer.Relation;
import edu.cmu.sphinx.alignment.tokenizer.Utterance;
import java.util.StringTokenizer;

public class Item {
    private Relation ownerRelation;
    private ItemContents contents;
    private Item parent;
    private Item daughter;
    private Item next;
    private Item prev;

    public Item(Relation relation, ItemContents sharedContents) {
        this.ownerRelation = relation;
        this.contents = sharedContents != null ? sharedContents : new ItemContents();
        this.parent = null;
        this.daughter = null;
        this.next = null;
        this.prev = null;
        this.getSharedContents().addItemRelation(relation.getName(), this);
    }

    public Item getItemAs(String relationName) {
        return this.getSharedContents().getItemRelation(relationName);
    }

    public Relation getOwnerRelation() {
        return this.ownerRelation;
    }

    public ItemContents getSharedContents() {
        return this.contents;
    }

    public boolean hasDaughters() {
        return this.daughter != null;
    }

    public Item getDaughter() {
        return this.daughter;
    }

    public Item getNthDaughter(int which) {
        Item d = this.daughter;
        int count = 0;
        while (count++ != which && d != null) {
            d = d.next;
        }
        return d;
    }

    public Item getLastDaughter() {
        Item d = this.daughter;
        if (d == null) {
            return null;
        }
        while (d.next != null) {
            d = d.next;
        }
        return d;
    }

    public Item addDaughter(Item item) {
        Item newItem;
        Item p = this.getLastDaughter();
        if (p != null) {
            newItem = p.appendItem(item);
        } else {
            ItemContents contents = item == null ? new ItemContents() : item.getSharedContents();
            newItem = new Item(this.getOwnerRelation(), contents);
            newItem.parent = this;
            this.daughter = newItem;
        }
        return newItem;
    }

    public Item createDaughter() {
        return this.addDaughter(null);
    }

    public Item getParent() {
        Item n = this;
        while (n.prev != null) {
            n = n.prev;
        }
        return n.parent;
    }

    public Utterance getUtterance() {
        return this.getOwnerRelation().getUtterance();
    }

    public FeatureSet getFeatures() {
        return this.getSharedContents().getFeatures();
    }

    public Object findFeature(String pathAndFeature) {
        String path;
        String feature;
        Object results = null;
        int lastDot = pathAndFeature.lastIndexOf(".");
        if (lastDot == -1) {
            feature = pathAndFeature;
            path = null;
        } else {
            feature = pathAndFeature.substring(lastDot + 1);
            path = pathAndFeature.substring(0, lastDot);
        }
        Item item = this.findItem(path);
        if (item != null) {
            results = item.getFeatures().getObject(feature);
        }
        results = results == null ? "0" : results;
        return results;
    }

    public Item findItem(String path) {
        Item pitem = this;
        if (path == null) {
            return this;
        }
        StringTokenizer tok = new StringTokenizer(path, ":.");
        while (pitem != null && tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals("n")) {
                pitem = pitem.getNext();
                continue;
            }
            if (token.equals("p")) {
                pitem = pitem.getPrevious();
                continue;
            }
            if (token.equals("nn")) {
                if ((pitem = pitem.getNext()) == null) continue;
                pitem = pitem.getNext();
                continue;
            }
            if (token.equals("pp")) {
                if ((pitem = pitem.getPrevious()) == null) continue;
                pitem = pitem.getPrevious();
                continue;
            }
            if (token.equals("parent")) {
                pitem = pitem.getParent();
                continue;
            }
            if (token.equals("daughter") || token.equals("daughter1")) {
                pitem = pitem.getDaughter();
                continue;
            }
            if (token.equals("daughtern")) {
                pitem = pitem.getLastDaughter();
                continue;
            }
            if (token.equals("R")) {
                String relationName = tok.nextToken();
                pitem = pitem.getSharedContents().getItemRelation(relationName);
                continue;
            }
            System.out.println("findItem: bad feature " + token + " in " + path);
        }
        return pitem;
    }

    public Item getNext() {
        return this.next;
    }

    public Item getPrevious() {
        return this.prev;
    }

    public Item appendItem(Item originalItem) {
        ItemContents contents = originalItem == null ? null : originalItem.getSharedContents();
        Item newItem = new Item(this.getOwnerRelation(), contents);
        newItem.next = this.next;
        if (this.next != null) {
            this.next.prev = newItem;
        }
        this.attach(newItem);
        if (this.ownerRelation.getTail() == this) {
            this.ownerRelation.setTail(newItem);
        }
        return newItem;
    }

    void attach(Item item) {
        this.next = item;
        item.prev = this;
    }

    public Item prependItem(Item originalItem) {
        ItemContents contents = originalItem == null ? null : originalItem.getSharedContents();
        Item newItem = new Item(this.getOwnerRelation(), contents);
        newItem.prev = this.prev;
        if (this.prev != null) {
            this.prev.next = newItem;
        }
        newItem.next = this;
        this.prev = newItem;
        if (this.parent != null) {
            this.parent.daughter = newItem;
            newItem.parent = this.parent;
            this.parent = null;
        }
        if (this.ownerRelation.getHead() == this) {
            this.ownerRelation.setHead(newItem);
        }
        return newItem;
    }

    public String toString() {
        String name = this.getFeatures().getString("name");
        if (name == null) {
            name = "";
        }
        return name;
    }

    public boolean equalsShared(Item otherItem) {
        if (otherItem == null) {
            return false;
        }
        return this.getSharedContents().equals(otherItem.getSharedContents());
    }
}

