/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.PathExtractor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DecisionTree {
    private static final Logger logger = Logger.getLogger(DecisionTree.class.getSimpleName());
    static final String TOTAL = "TOTAL";
    static final String NODE = "NODE";
    static final String LEAF = "LEAF";
    static final String OPERAND_MATCHES = "MATCHES";
    Node[] cart = null;
    transient int curNode = 0;

    public DecisionTree(URL url) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("***")) {
                this.parseAndAdd(line);
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public DecisionTree(BufferedReader reader, int nodes) throws IOException {
        this(nodes);
        for (int i = 0; i < nodes; ++i) {
            String line = reader.readLine();
            if (line.startsWith("***")) continue;
            this.parseAndAdd(line);
        }
    }

    private DecisionTree(int numNodes) {
        this.cart = new Node[numNodes];
    }

    public void dumpDot(PrintWriter out) {
        out.write("digraph \"CART Tree\" {\n");
        out.write("rankdir = LR\n");
        for (Node n : this.cart) {
            out.println("\t\"node" + n.hashCode() + "\" [ label=\"" + n.toString() + "\", color=" + this.dumpDotNodeColor(n) + ", shape=" + this.dumpDotNodeShape(n) + " ]\n");
            if (!(n instanceof DecisionNode)) continue;
            DecisionNode dn = (DecisionNode)n;
            if (dn.qtrue < this.cart.length && this.cart[dn.qtrue] != null) {
                out.write("\t\"node" + n.hashCode() + "\" -> \"node" + this.cart[dn.qtrue].hashCode() + "\" [ label=" + "TRUE" + " ]\n");
            }
            if (dn.qfalse >= this.cart.length || this.cart[dn.qfalse] == null) continue;
            out.write("\t\"node" + n.hashCode() + "\" -> \"node" + this.cart[dn.qfalse].hashCode() + "\" [ label=" + "FALSE" + " ]\n");
        }
        out.write("}\n");
        out.close();
    }

    protected String dumpDotNodeColor(Node n) {
        if (n instanceof LeafNode) {
            return "green";
        }
        return "red";
    }

    protected String dumpDotNodeShape(Node n) {
        return "box";
    }

    protected void parseAndAdd(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        String type = tokenizer.nextToken();
        if (type.equals(LEAF) || type.equals(NODE)) {
            this.cart[this.curNode] = this.getNode(type, tokenizer, this.curNode);
            this.cart[this.curNode].setCreationLine(line);
            ++this.curNode;
        } else if (type.equals(TOTAL)) {
            this.cart = new Node[Integer.parseInt(tokenizer.nextToken())];
            this.curNode = 0;
        } else {
            throw new Error("Invalid CART type: " + type);
        }
    }

    protected Node getNode(String type, StringTokenizer tokenizer, int currentNode) {
        if (type.equals(NODE)) {
            String feature = tokenizer.nextToken();
            String operand = tokenizer.nextToken();
            Object value = this.parseValue(tokenizer.nextToken());
            int qfalse = Integer.parseInt(tokenizer.nextToken());
            if (operand.equals(OPERAND_MATCHES)) {
                return new MatchingNode(feature, value.toString(), currentNode + 1, qfalse);
            }
            return new ComparisonNode(feature, value, operand, currentNode + 1, qfalse);
        }
        if (type.equals(LEAF)) {
            return new LeafNode(this.parseValue(tokenizer.nextToken()));
        }
        return null;
    }

    protected Object parseValue(String string) {
        int openParen = string.indexOf("(");
        String type = string.substring(0, openParen);
        String value = string.substring(openParen + 1, string.length() - 1);
        if (type.equals("String")) {
            return value;
        }
        if (type.equals("Float")) {
            return new Float(Float.parseFloat(value));
        }
        if (type.equals("Integer")) {
            return new Integer(Integer.parseInt(value));
        }
        if (type.equals("List")) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            int size = tok.countTokens();
            int[] values = new int[size];
            for (int i = 0; i < size; ++i) {
                float fval = Float.parseFloat(tok.nextToken());
                values[i] = Math.round(fval);
            }
            return values;
        }
        throw new Error("Unknown type: " + type);
    }

    public Object interpret(Item item) {
        int nodeIndex = 0;
        while (!(this.cart[nodeIndex] instanceof LeafNode)) {
            DecisionNode decision = (DecisionNode)this.cart[nodeIndex];
            nodeIndex = decision.getNextNode(item);
        }
        logger.fine("LEAF " + this.cart[nodeIndex].getValue());
        return ((LeafNode)this.cart[nodeIndex]).getValue();
    }

    static class LeafNode
    extends Node {
        public LeafNode(Object value) {
            super(value);
        }

        public String toString() {
            return "LEAF " + this.getValueString();
        }
    }

    static class MatchingNode
    extends DecisionNode {
        Pattern pattern;

        public MatchingNode(String feature, String regex, int qtrue, int qfalse) {
            super(feature, regex, qtrue, qfalse);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public int getNextNode(Object val) {
            return this.pattern.matcher((String)val).matches() ? this.qtrue : this.qfalse;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("NODE " + this.getFeature() + " " + DecisionTree.OPERAND_MATCHES);
            buf.append(this.getValueString() + " ");
            buf.append(Integer.toString(this.qtrue) + " ");
            buf.append(Integer.toString(this.qfalse));
            return buf.toString();
        }
    }

    static class ComparisonNode
    extends DecisionNode {
        static final String LESS_THAN = "<";
        static final String EQUALS = "=";
        static final String GREATER_THAN = ">";
        String comparisonType;

        public ComparisonNode(String feature, Object value, String comparisonType, int qtrue, int qfalse) {
            super(feature, value, qtrue, qfalse);
            if (!(comparisonType.equals(LESS_THAN) || comparisonType.equals(EQUALS) || comparisonType.equals(GREATER_THAN))) {
                throw new Error("Invalid comparison type: " + comparisonType);
            }
            this.comparisonType = comparisonType;
        }

        @Override
        public int getNextNode(Object val) {
            boolean yes = false;
            if (this.comparisonType.equals(LESS_THAN) || this.comparisonType.equals(GREATER_THAN)) {
                float cart_fval = this.value instanceof Float ? ((Float)this.value).floatValue() : Float.parseFloat(this.value.toString());
                float fval = val instanceof Float ? ((Float)val).floatValue() : Float.parseFloat(val.toString());
                yes = this.comparisonType.equals(LESS_THAN) ? fval < cart_fval : fval > cart_fval;
            } else {
                String sval = val.toString();
                String cart_sval = this.value.toString();
                yes = sval.equals(cart_sval);
            }
            int ret = yes ? this.qtrue : this.qfalse;
            logger.fine(this.trace(val, yes, ret));
            return ret;
        }

        private String trace(Object value, boolean match, int next) {
            return "NODE " + this.getFeature() + " [" + value + "] " + this.comparisonType + " [" + this.getValue() + "] " + (match ? "Yes" : "No") + " next " + next;
        }

        public String toString() {
            return "NODE " + this.getFeature() + " " + this.comparisonType + " " + this.getValueString() + " " + Integer.toString(this.qtrue) + " " + Integer.toString(this.qfalse);
        }
    }

    static abstract class DecisionNode
    extends Node {
        private PathExtractor path;
        protected int qfalse;
        protected int qtrue;

        public String getFeature() {
            return this.path.toString();
        }

        public Object findFeature(Item item) {
            return this.path.findFeature(item);
        }

        public final int getNextNode(Item item) {
            return this.getNextNode(this.findFeature(item));
        }

        public DecisionNode(String feature, Object value, int qtrue, int qfalse) {
            super(value);
            this.path = new PathExtractor(feature, true);
            this.qtrue = qtrue;
            this.qfalse = qfalse;
        }

        public abstract int getNextNode(Object var1);
    }

    static abstract class Node {
        protected Object value;

        public Node(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueString() {
            if (this.value == null) {
                return "NULL()";
            }
            if (this.value instanceof String) {
                return "String(" + this.value.toString() + ")";
            }
            if (this.value instanceof Float) {
                return "Float(" + this.value.toString() + ")";
            }
            if (this.value instanceof Integer) {
                return "Integer(" + this.value.toString() + ")";
            }
            return this.value.getClass().toString() + "(" + this.value.toString() + ")";
        }

        public void setCreationLine(String line) {
        }
    }
}

