/*
 * Decompiled with CFR 0.152.
 */
package com.apmods.hpspells.main;

import com.apmods.hpspells.block.BlockManager;
import com.apmods.hpspells.command.CommandLearnAll;
import com.apmods.hpspells.entity.EntityManager;
import com.apmods.hpspells.handler.DarkArtsHandler;
import com.apmods.hpspells.handler.LumosHandler;
import com.apmods.hpspells.handler.SkillsHandler;
import com.apmods.hpspells.inventory.HPSpellsGuiHandler;
import com.apmods.hpspells.item.ItemManager;
import com.apmods.hpspells.lib.SpellLib;
import com.apmods.hpspells.network.HPNetwork;
import com.apmods.hpspells.potion.PotionFlipped;
import com.apmods.hpspells.proxy.CommonProxy;
import com.apmods.hpspells.speech.HPSpellsSpeechRecognizer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import edu.cmu.sphinx.api.Configuration;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.command.ICommand;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="hpspells", version="1.0", name="\u00a75HP Spells")
public class HPSpells {
    @Mod.Instance
    public static HPSpells instance;
    public static final String MODID = "hpspells";
    public static final String VERSION = "1.0";
    public static boolean isDarkMagicAllowed;
    public static Configuration speechConfig;
    public static HPSpellsSpeechRecognizer lsp;
    public static Potion flipped;
    public static ResourceLocation potionIcons;
    @SidedProxy(clientSide="com.apmods.hpspells.proxy.ClientProxy", serverSide="com.apmods.hpspells.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        net.minecraftforge.common.config.Configuration config = new net.minecraftforge.common.config.Configuration(event.getSuggestedConfigurationFile());
        config.load();
        isDarkMagicAllowed = config.get("Magic Permissions", "Are The Dark Arts Allowed", true, "Whether Players can use Avada Kedavra, Crucio, Confringo, and Imperio").getBoolean();
        config.save();
        this.preInitPotions();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        BlockManager.init();
        ItemManager.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new HPSpellsGuiHandler());
        FMLCommonHandler.instance().bus().register((Object)new LumosHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SkillsHandler());
        FMLCommonHandler.instance().bus().register((Object)new SkillsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DarkArtsHandler());
        HPNetwork.init();
        EntityManager.init();
        SpellLib.init();
        speechConfig = new Configuration();
        speechConfig.setAcousticModelPath("resource:/edu/cmu/sphinx/models/en-us/en-us");
        speechConfig.setDictionaryPath("resource:/assets/hpspells/speech/spells.dic");
        speechConfig.setLanguageModelPath("resource:/assets/hpspells/speech/spells.lm");
        try {
            lsp = new HPSpellsSpeechRecognizer(speechConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        flipped = new PotionFlipped(32, false, 0xEEEEEE, potionIcons).func_76399_b(0, 0).func_76390_b("potion.flipped.name");
    }

    private void preInitPotions() {
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[256];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                System.err.println("Severe error, please report this to the mod author:");
                System.err.println(e);
            }
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandLearnAll());
    }

    static {
        potionIcons = new ResourceLocation("hpspells:textures/potion/potionIcons.png");
    }
}

