/*
 * Decompiled with CFR 0.152.
 */
package com.apmods.hpspells.handler;

import com.apmods.hpspells.entity.EntityBroomstick;
import com.apmods.hpspells.extendedplayer.SpellSkills;
import com.apmods.hpspells.item.ItemManager;
import com.apmods.hpspells.network.BroomstickPacket;
import com.apmods.hpspells.network.HPNetwork;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SkillsHandler {
    private static final String NBT_KEY = "hpspells.firstjoin";

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && SpellSkills.get((EntityPlayer)event.entity) == null) {
            SpellSkills.register((EntityPlayer)event.entity);
            EntityPlayer entityPlayer = (EntityPlayer)event.entity;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K) {
            SpellSkills.loadProxyData((EntityPlayer)event.entity);
            SpellSkills.get((EntityPlayer)event.entity).setSpeaking(false);
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound persistent;
        NBTTagCompound data = event.player.getEntityData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new NBTTagCompound();
            data.func_74782_a("PlayerPersisted", (NBTBase)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        if (!persistent.func_74764_b(NBT_KEY)) {
            persistent.func_74757_a(NBT_KEY, true);
            event.player.field_71071_by.func_70441_a(new ItemStack(ItemManager.wand));
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            SpellSkills.saveProxyData((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side.isServer()) {
            SpellSkills ext = SpellSkills.get(evt.player);
            if (ext.getCastProtegoCounter() != 0) {
                ext.addCastProtegoCounter();
            }
            if (ext.hasProtego()) {
                ext.addProtegoCounter();
                if (ext.getProtegoCounter() <= 0) {
                    ext.resetProtegoCounter();
                    ext.disableProtego();
                    evt.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Protego Shield Deactivated"));
                }
            }
        } else if (evt.player.field_70154_o != null && evt.player.field_70154_o instanceof EntityBroomstick) {
            EntityBroomstick broomstick = (EntityBroomstick)evt.player.field_70154_o;
            if (!broomstick.isYLocked() && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
                HPNetwork.net.sendToServer((IMessage)new BroomstickPacket.BroomstickMessage(true));
            } else if (broomstick.isYLocked() && !Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
                HPNetwork.net.sendToServer((IMessage)new BroomstickPacket.BroomstickMessage(false));
            }
        }
    }
}

