/*
 * Decompiled with CFR 0.152.
 */
package com.apmods.hpspells.extendedplayer;

import com.apmods.hpspells.lib.SpellLib;
import com.apmods.hpspells.network.HPNetwork;
import com.apmods.hpspells.network.SyncSkillsPacket;
import com.apmods.hpspells.proxy.CommonProxy;
import com.apmods.hpspells.spell.ISpell;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class SpellSkills
implements IExtendedEntityProperties {
    public static final String MAGICSKILLS = "Magic Skill";
    private final EntityPlayer player;
    private int patronusID;
    private int[] knowledge = new int[SpellLib.names.length];
    private int overallSkill;
    private int[] skill = new int[SpellLib.names.length];
    private int[] skillLevel = new int[SpellLib.names.length];
    private boolean protego;
    private boolean isSpeaking;
    private int protegoCounter;
    private int castProtegoCounter;
    private int portkeyX;
    private int portkeyY;
    private int portkeyZ;
    private int heldEntityID;
    private boolean isAscending;

    public SpellSkills(EntityPlayer player) {
        int i;
        this.player = player;
        this.protego = false;
        this.isSpeaking = false;
        this.protegoCounter = 280;
        this.castProtegoCounter = 400;
        this.portkeyX = 0;
        this.portkeyY = 0;
        this.portkeyZ = 0;
        this.isAscending = false;
        this.heldEntityID = 0;
        Random rand = new Random();
        this.patronusID = rand.nextInt(20);
        for (i = 0; i < this.knowledge.length; ++i) {
            this.knowledge[i] = 0;
        }
        for (i = 0; i < this.skill.length; ++i) {
            this.skill[i] = 0;
        }
        for (i = 0; i < this.skillLevel.length; ++i) {
            this.skillLevel[i] = 0;
        }
        this.overallSkill = 0;
        this.knowledge[SpellLib.getSpell((String)"Flipendo").getSpellIndex()] = 1;
        this.knowledge[SpellLib.getSpell((String)"Duro").getSpellIndex()] = 1;
        this.knowledge[SpellLib.getSpell((String)"Multicolorfors").getSpellIndex()] = 1;
        this.knowledge[SpellLib.getSpell((String)"Orchideous").getSpellIndex()] = 1;
    }

    public static final SpellSkills get(EntityPlayer player) {
        return (SpellSkills)player.getExtendedProperties(MAGICSKILLS);
    }

    public void saveNBTData(NBTTagCompound compound) {
        int i;
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("patronus", this.patronusID);
        for (i = 0; i < this.knowledge.length; ++i) {
            properties.func_74768_a(SpellLib.names[i] + "_fizzle", this.knowledge[i]);
        }
        for (i = 0; i < this.skill.length; ++i) {
            properties.func_74768_a(SpellLib.names[i] + "_skill", this.skill[i]);
        }
        for (i = 0; i < this.skillLevel.length; ++i) {
            properties.func_74768_a(SpellLib.names[i] + "_level", this.skillLevel[i]);
        }
        properties.func_74768_a("overallSkill", this.overallSkill);
        properties.func_74757_a("protego", this.protego);
        properties.func_74768_a("protegoCounter", this.protegoCounter);
        properties.func_74768_a("castProtegoCounter", this.castProtegoCounter);
        properties.func_74757_a("isSpeaking", this.isSpeaking);
        properties.func_74768_a("portkeyX", this.portkeyX);
        properties.func_74768_a("portkeyY", this.portkeyY);
        properties.func_74768_a("portkeyZ", this.portkeyZ);
        properties.func_74757_a("isAscending", this.isAscending);
        compound.func_74782_a(MAGICSKILLS, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        int i;
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(MAGICSKILLS);
        this.patronusID = properties.func_74762_e("patronus");
        for (i = 0; i < this.knowledge.length; ++i) {
            this.knowledge[i] = properties.func_74762_e(SpellLib.names[i] + "_fizzle");
        }
        this.overallSkill = properties.func_74762_e("overallSkill");
        for (i = 0; i < this.skill.length; ++i) {
            this.skill[i] = properties.func_74762_e(SpellLib.names[i] + "_skill");
        }
        for (i = 0; i < this.skillLevel.length; ++i) {
            this.skillLevel[i] = properties.func_74762_e(SpellLib.names[i] + "_level");
        }
        this.protego = properties.func_74767_n("protego");
        this.protegoCounter = properties.func_74762_e("protegoCounter");
        this.castProtegoCounter = properties.func_74762_e("castProtegoCounter");
        this.isSpeaking = properties.func_74767_n("isSpeaking");
        this.portkeyX = properties.func_74762_e("portkeyX");
        this.portkeyY = properties.func_74762_e("portkeyY");
        this.portkeyZ = properties.func_74762_e("portkeyZ");
        this.isAscending = properties.func_74767_n("isAscending");
    }

    public void init(Entity entity, World world) {
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(MAGICSKILLS, (IExtendedEntityProperties)new SpellSkills(player));
    }

    private static String getSaveKey(EntityPlayer player) {
        return player.getDisplayName() + ":" + MAGICSKILLS;
    }

    public static void saveProxyData(EntityPlayer player) {
        SpellSkills ext = SpellSkills.get(player);
        NBTTagCompound savedData = new NBTTagCompound();
        ext.removeHeldEntity();
        ext.saveNBTData(savedData);
        CommonProxy.storeEntityData(SpellSkills.getSaveKey(player), savedData);
    }

    public static void loadProxyData(EntityPlayer player) {
        SpellSkills ext = SpellSkills.get(player);
        NBTTagCompound savedData = CommonProxy.getEntityData(SpellSkills.getSaveKey(player));
        if (savedData != null) {
            ext.loadNBTData(savedData);
        }
        ext.syncProperties();
    }

    public void syncProperties() {
        if (this.player instanceof EntityPlayerMP) {
            HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
        }
    }

    public void learnAll() {
        for (int i = 1; i < this.knowledge.length; ++i) {
            this.knowledge[i] = SpellLib.getSpell(SpellLib.names[i]).isComplicated() ? 3 : 2;
        }
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getPatronusID() {
        return this.patronusID;
    }

    public void addSkillLevel(int skillof) {
        int n = skillof;
        this.skillLevel[n] = this.skillLevel[n] + 1;
        if (this.skillLevel[skillof] >= 7) {
            this.skillLevel[skillof] = 6;
        }
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public void gainSkill(ISpell spell) {
        int index;
        int n = index = spell.getSpellIndex();
        this.skill[n] = this.skill[n] + 1;
        ++this.overallSkill;
        if (this.skill[index] % 35 == 0 && this.skillLevel[index] < 6) {
            this.addSkillLevel(index);
            this.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "[MagiCraft]" + EnumChatFormatting.RESET + " You leveled up your " + EnumChatFormatting.DARK_PURPLE + spell.getName() + EnumChatFormatting.RESET + " skill! " + "Current Level: " + EnumChatFormatting.DARK_PURPLE + this.getCurrentSkillLevel(spell)));
        }
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getCurrentSkillLevel(ISpell spell) {
        return this.skillLevel[spell.getSpellIndex()];
    }

    public int getCurrentSkill(ISpell spell) {
        return this.skill[spell.getSpellIndex()];
    }

    public int getKnowledgeLevel(ISpell spell) {
        int i = spell.getSpellIndex();
        return this.knowledge[spell.getSpellIndex()];
    }

    public void addKnowledgeLevel(ISpell spell) {
        if (!this.isKnowledgeMaxed(spell)) {
            int n = spell.getSpellIndex();
            this.knowledge[n] = this.knowledge[n] + 1;
        }
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public boolean isKnowledgeMaxed(ISpell spell) {
        return spell.isComplicated() ? this.getKnowledgeLevel(spell) >= 3 : this.getKnowledgeLevel(spell) >= 2;
    }

    public boolean knowsSpell(ISpell spell) {
        return this.getKnowledgeLevel(spell) > 0;
    }

    public void enableProtego() {
        this.protego = true;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public void disableProtego() {
        this.protego = false;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public boolean hasProtego() {
        return this.protego;
    }

    public void resetProtegoCounter() {
        this.protegoCounter = 280;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getProtegoCounter() {
        return this.protegoCounter;
    }

    public void addProtegoCounter() {
        --this.protegoCounter;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public void resetCastProtegoCounter() {
        this.castProtegoCounter = 400;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getCastProtegoCounter() {
        return this.castProtegoCounter;
    }

    public void addCastProtegoCounter() {
        --this.castProtegoCounter;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public boolean isSpeaking() {
        return this.isSpeaking;
    }

    public void setSpeaking(boolean isSpeaking) {
        this.isSpeaking = isSpeaking;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getPortkeyX() {
        return this.portkeyX;
    }

    public void setPortkeyX(int portkeyX) {
        this.portkeyX = portkeyX;
    }

    public int getPortkeyY() {
        return this.portkeyY;
    }

    public void setPortkeyY(int portkeyY) {
        this.portkeyY = portkeyY;
    }

    public int getPortkeyZ() {
        return this.portkeyZ;
    }

    public void setPortkeyZ(int portkeyZ) {
        this.portkeyZ = portkeyZ;
    }

    public int getHeldEntity() {
        return this.heldEntityID;
    }

    public void setHeldEntity(Entity heldEntity) {
        this.heldEntityID = heldEntity.func_145782_y();
    }

    public void removeHeldEntity() {
        this.heldEntityID = 0;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public void setAscending(boolean isAscending) {
        this.isAscending = isAscending;
        HPNetwork.net.sendTo((IMessage)new SyncSkillsPacket.SkillsMessage(this.player), (EntityPlayerMP)this.player);
    }
}

