/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.handler;

import java.io.File;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static boolean doWorldGen;
    public static boolean doSpecialWorldGen;
    public static int torcherRange;
    public static int torcherFrequency;
    public static int sapDurability;
    public static int maxStaffFlyHeight;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("pearcelmod")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        doWorldGen = configuration.getBoolean(StatCollector.func_74838_a((String)"config.doWorldGen.title"), "general", true, StatCollector.func_74838_a((String)"config.doWorldGen.desc"));
        doSpecialWorldGen = configuration.getBoolean(StatCollector.func_74838_a((String)"config.doSpecialWorldGen.title"), "general", true, StatCollector.func_74838_a((String)"config.doSpecialWorldGen.desc"));
        torcherRange = configuration.getInt(StatCollector.func_74838_a((String)"config.torcherRange.title"), "general", 25, 1, Integer.MAX_VALUE, StatCollector.func_74838_a((String)"config.torcherRange.desc"));
        torcherFrequency = configuration.getInt(StatCollector.func_74838_a((String)"config.torcherFrequency.title"), "general", 2, 2, Integer.MAX_VALUE, StatCollector.func_74838_a((String)"config.torcherFrequency.desc"));
        sapDurability = configuration.getInt(StatCollector.func_74838_a((String)"config.sapDurability.title"), "general", 32, 1, Integer.MAX_VALUE, StatCollector.func_74838_a((String)"config.sapDurability.desc"));
        maxStaffFlyHeight = configuration.getInt(StatCollector.func_74838_a((String)"config.maxStaffFlyHeight.title"), "general", 150, 1, 256, StatCollector.func_74838_a((String)"config.maxStaffFlyHeight.desc"));
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }
}

