/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.plainsmobs.entity;

import java.util.ArrayList;
import java.util.HashMap;
import lycanite.lycanitesmobs.api.IGroupAlpha;
import lycanite.lycanitesmobs.api.IGroupHunter;
import lycanite.lycanitesmobs.api.IGroupPredator;
import lycanite.lycanitesmobs.api.IGroupPrey;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAvoid;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowOwner;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIGetBlock;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIGetItem;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAvoid;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerThreats;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityKobold
extends EntityCreatureTameable
implements IMob,
IGroupPrey {
    public boolean torchGreifing = ConfigBase.getConfig(this.group, "general").getBool("Features", "Kobold Torch Griefing", this.torchGreifing, "Set to false to stop Kobolds from stealing torches.");
    private int torchLootingTime = 20;

    public EntityKobold(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.experience = 5;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = false;
        this.babySpawnChance = 0.1;
        this.setWidth = 0.5f;
        this.setHeight = 0.9f;
        this.setupMob();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIGetItem(this).setDistanceMax(32.0).setSpeed(1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAvoid(this).setNearSpeed(1.8).setFarSpeed(1.4).setNearDistance(3.0).setFarDistance(16.0));
        if (this.torchGreifing) {
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIGetBlock(this).setDistanceMax(8).setSpeed(1.2).setBlockName("torch").setTamedLooting(false));
        }
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupAlpha.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 10.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        baseAttributes.put("attackSpeed", 4.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151044_h), 0.25f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(Items.field_151042_j), 0.05f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(Items.field_151074_bl), 0.025f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(Items.field_151166_bC), 0.01f).setMaxAmount(1));
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.inventory.hasBagItems()) {
            return false;
        }
        return super.func_70692_ba();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && this.torchGreifing && this.torchLootingTime-- <= 0) {
            this.torchLootingTime = 60;
            int distance = 2;
            String targetName = "torch";
            ArrayList possibleTargets = new ArrayList();
            for (int x = (int)this.field_70165_t - distance; x < (int)this.field_70165_t + distance; ++x) {
                block1: for (int y = (int)this.field_70163_u - distance; y < (int)this.field_70163_u + distance; ++y) {
                    for (int z = (int)this.field_70161_v - distance; z < (int)this.field_70161_v + distance; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block searchBlock = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (searchBlock == null || searchBlock == Blocks.field_150350_a) continue;
                        Object possibleTarget = null;
                        if (!ObjectLists.isName(searchBlock, targetName)) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity.func_110143_aJ() / targetEntity.func_110138_aP() > 0.5f) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public int getNoBagSize() {
        return 10;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean canPickupItems() {
        return ConfigBase.getConfig(this.group, "general").getBool("Features", "Kobold Thievery", true, "Set to false to prevent Kobold from collecting items.");
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76419_f) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityKobold(this.field_70170_p);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

