/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.mountainmobs.entity;

import java.util.HashMap;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupRock;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowOwner;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerThreats;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityGeonach
extends EntityCreatureTameable
implements IMob,
IGroupRock {
    private EntityAIAttackMelee meleeAttackAI;
    public int geonachBlockBreakRadius = 0;

    public EntityGeonach(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 3;
        this.experience = 5;
        this.hasAttackSound = true;
        this.geonachBlockBreakRadius = ConfigBase.getConfig(this.group, "general").getInt("Features", "Rare Geonach Block Break Radius", this.geonachBlockBreakRadius, "Controls how large the Celestial Geonach's block breaking radius is when it is charging towards its target. Set to -1 to disable. For their block breaking radius on spawn, see the ROCK spawn type features instead. Note that this is only for the extremely rare Geonach.");
        this.setWidth = 0.8f;
        this.setHeight = 1.8f;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackPhaseMax = (byte)3;
        this.justAttackedTime = (short)10;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.meleeAttackAI = new EntityAIAttackMelee(this).setRate(20).setLongMemory(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAttackAI);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySilverfish.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150348_b), 1.0f).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150366_p), 0.75f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(Items.field_151128_bU), 0.75f).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150352_o), 0.1f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("soulstonemountain")), 1.0f).setMaxAmount(1).setSubspecies(3));
    }

    @Override
    public void func_70105_a(float width, float height) {
        if (this.getSubspeciesIndex() == 3) {
            super.func_70105_a(width * 2.0f, height * 2.0f);
            return;
        }
        super.func_70105_a(width, height);
    }

    @Override
    public double getRenderScale() {
        if (this.getSubspeciesIndex() == 3) {
            return this.sizeScale * 2.0;
        }
        return this.sizeScale;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.getSubspeciesIndex() == 3 && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70068_e((Entity)this.func_70638_az()) > 1.0 && this.func_70681_au().nextInt(20) == 0) {
            if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
            } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
            } else {
                this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
            }
            if (this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && this.geonachBlockBreakRadius > -1 && !this.isTamed()) {
                this.destroyArea((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10.0f, true, this.geonachBlockBreakRadius);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                int[] nArray = new int[1];
                nArray[0] = BlockTallGrass.func_176210_f((IBlockState)Blocks.field_150348_b.func_176223_P());
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, nArray);
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.hasAttackTarget() && this.func_70638_az() instanceof EntitySilverfish) {
            return 4.0f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            if (this.getAttackPhase() == 2 && ObjectManager.getPotionEffect("weight") != null) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect((Potion)ObjectManager.getPotionEffect("weight"), this.getEffectDuration(7), 0));
            } else {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76419_f, this.getEffectDuration(7), 0));
            }
        }
        this.nextAttackPhase();
        if (this.getAttackPhase() == 2) {
            this.meleeAttackAI.setRate(60);
        } else {
            this.meleeAttackAI.setRate(10);
        }
        if (target instanceof EntitySilverfish) {
            target.func_70106_y();
        }
        return true;
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76346_g() != null) {
            EntityLivingBase entityLiving;
            if (damageSrc.func_76346_g() instanceof EntitySilverfish) {
                return 0.0f;
            }
            Item heldItem = null;
            if (damageSrc.func_76346_g() instanceof EntityLivingBase && (entityLiving = (EntityLivingBase)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND) != null) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            }
            if (ObjectLists.isPickaxe(heldItem)) {
                return 4.0f;
            }
        }
        return 1.0f;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76419_f) {
            return false;
        }
        if (ObjectManager.getPotionEffect("weight") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("weight")) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public boolean canBurn() {
        return false;
    }
}

