/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.mountainmobs.entity;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAlpha;
import lycanite.lycanitesmobs.api.IGroupAnimal;
import lycanite.lycanitesmobs.api.IGroupPredator;
import lycanite.lycanitesmobs.api.IGroupPrey;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureRideable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIBeg;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowParent;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRiderAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRiderRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITempt;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityBarghest
extends EntityCreatureRideable
implements IGroupPredator {
    protected boolean leapedAbilityQueued = false;
    protected boolean leapedAbilityReady = false;

    public EntityBarghest(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setWidth = 0.8f;
        this.setHeight = 1.5f;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("barghesttreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAlpha.class).setPackHuntingScale(1, 1));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class).setPackHuntingScale(1, 3));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class).setPackHuntingScale(1, 3));
        }
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 3.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151116_aA), 1.0f).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Items.field_151103_aS), 0.5f).setMaxAmount(2));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.field_70122_E && !this.field_70170_p.field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(4.0f, 0.7, (Entity)this.func_70638_az());
        }
        if (this.leapedAbilityQueued && !this.field_70122_E && !this.field_70170_p.field_72995_K) {
            this.leapedAbilityQueued = false;
            this.leapedAbilityReady = true;
        }
        if (this.leapedAbilityReady && this.field_70122_E && !this.field_70170_p.field_72995_K) {
            this.leapedAbilityReady = false;
            double distance = 4.0;
            List possibleTargets = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase possibleTarget) {
                    return possibleTarget.func_70089_S() && possibleTarget != EntityBarghest.this && !EntityBarghest.this.func_184215_y((Entity)possibleTarget) && !EntityBarghest.this.func_184191_r((Entity)possibleTarget) && !EntityBarghest.this.func_70686_a(possibleTarget.getClass()) && !EntityBarghest.this.canAttackEntity(possibleTarget);
                }
            });
            if (!possibleTargets.isEmpty()) {
                for (EntityLivingBase possibleTarget : possibleTargets) {
                    boolean doDamage = true;
                    if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget))) {
                        doDamage = false;
                    }
                    if (!doDamage) continue;
                    if (ObjectManager.getPotionEffect("weight") != null) {
                        possibleTarget.func_70690_d(new PotionEffect((Potion)ObjectManager.getPotionEffect("weight"), this.getEffectDuration(5), 1));
                        continue;
                    }
                    possibleTarget.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                }
            }
            this.playAttackSound();
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_76419_f)) {
            rider.func_184589_d(MobEffects.field_76419_f);
        }
        if (rider.func_70644_a((Potion)ObjectManager.getPotionEffect("weight"))) {
            rider.func_184589_d((Potion)ObjectManager.getPotionEffect("weight"));
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (!this.field_70122_E) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.8;
    }

    @Override
    public void leap(double distance, double leapHeight) {
        super.leap(distance, leapHeight);
        if (!this.field_70170_p.field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void leap(float range, double leapHeight, Entity target) {
        super.leap(range, leapHeight, target);
        if (!this.field_70170_p.field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase && this.leapedAbilityReady && ObjectManager.getPotionEffect("weight") != null) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect((Potion)ObjectManager.getPotionEffect("weight"), this.getEffectDuration(4), 0));
        }
        return true;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.field_70122_E) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.playJumpSound();
        this.leap(2.0, 1.5);
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 15.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76419_f) {
            return false;
        }
        if (ObjectManager.getPotionEffect("weight") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("weight")) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityBarghest(this.field_70170_p);
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ObjectManager.getItem("barghesttreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack);
    }
}

