/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.junglemobs.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAnimal;
import lycanite.lycanitesmobs.api.IGroupPredator;
import lycanite.lycanitesmobs.api.IGroupPrey;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowMaster;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIPlaceBlock;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetMaster;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetMasterAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.junglemobs.entity.EntityConba;
import lycanite.lycanitesmobs.junglemobs.entity.EntityVespidQueen;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityVespid
extends EntityCreatureAgeable
implements IMob,
IGroupPredator {
    public EntityAIPlaceBlock aiPlaceBlock;
    private boolean vespidHiveBuilding = true;

    public EntityVespid(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = true;
        this.setWidth = 0.9f;
        this.setHeight = 1.5f;
        this.setupMob();
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.field_70138_W = 1.0f;
        this.justAttackedTime = (short)10;
        this.vespidHiveBuilding = ConfigBase.getConfig(this.group, "general").getBool("Features", "Vespid Hive Building", this.vespidHiveBuilding, "Set to false to stop Vespids from building hives all together.");
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setRate(10).setLongMemory(true));
        this.aiPlaceBlock = new EntityAIPlaceBlock(this).setMaxDistance(128.0).setSpeed(3.0);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiPlaceBlock);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowMaster(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this).setPauseRate(20));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetMasterAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true).setHelpClasses(EntityVespidQueen.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetMaster(this).setTargetClass(EntityVespidQueen.class).setDistance(64.0));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IAnimals.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 5.0);
        baseAttributes.put("movementSpeed", 0.32);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 24.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151119_aD), 0.5f).setMaxAmount(16));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("propolis")), 0.5f).setMaxAmount(4));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("veswax")), 0.5f).setMaxAmount(4));
    }

    @Override
    public boolean isPersistant() {
        if (this.hasMaster() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.field_70145_X) {
                if (this.isHiveBlock(this.func_180425_c())) {
                    this.field_70145_X = true;
                }
            } else if (!this.isHiveBlock(this.func_180425_c())) {
                this.field_70145_X = false;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.vespidHiveBuilding && this.hasMaster() && this.getMasterTarget() instanceof EntityVespidQueen && this.aiPlaceBlock.block == null) {
            EntityVespidQueen queen = (EntityVespidQueen)this.getMasterTarget();
            if (!queen.hiveFoundationsSet()) {
                int z;
                int endZ;
                int y;
                int endY;
                int x;
                int endX;
                ArrayList<Byte> directions = new ArrayList<Byte>();
                if (!queen.doesHiveHaveXPositive()) {
                    directions.add((byte)0);
                }
                if (!queen.doesHiveHaveXNegative()) {
                    directions.add((byte)1);
                }
                if (!queen.doesHiveHaveYPositive()) {
                    directions.add((byte)2);
                }
                if (!queen.doesHiveHaveYNegative()) {
                    directions.add((byte)3);
                }
                if (!queen.doesHiveHaveZPositive()) {
                    directions.add((byte)4);
                }
                if (!queen.doesHiveHaveZNegative()) {
                    directions.add((byte)5);
                }
                BlockPos hivePos = queen.getHivePosition();
                int hiveMin = 5;
                int hiveMinFloor = 3;
                int hiveMax = 16;
                int direction = 6;
                if (directions.size() == 1) {
                    direction = ((Byte)directions.get(0)).byteValue();
                } else if (directions.size() > 1) {
                    direction = ((Byte)directions.get(this.func_70681_au().nextInt(directions.size()))).byteValue();
                }
                if (direction == 0) {
                    x = endX = hivePos.func_177958_n();
                    while (x <= hivePos.func_177958_n() + hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) {
                        endX = x++;
                    }
                    if (endX >= hivePos.func_177958_n() + hiveMin) {
                        this.aiPlaceBlock.setMetadata(5);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax"), new BlockPos(endX, hivePos.func_177956_o(), hivePos.func_177952_p()));
                    }
                } else if (direction == 1) {
                    x = endX = hivePos.func_177958_n() - hiveMin;
                    while (x >= hivePos.func_177958_n() - hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) {
                        endX = x--;
                    }
                    if (endX <= hivePos.func_177958_n() - hiveMin) {
                        this.aiPlaceBlock.setMetadata(4);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax"), new BlockPos(endX, hivePos.func_177956_o(), hivePos.func_177952_p()));
                    }
                }
                if (direction == 2) {
                    y = endY = hivePos.func_177956_o() + hiveMin;
                    while (y <= hivePos.func_177956_o() + hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) {
                        endY = y++;
                    }
                    if (endY >= hivePos.func_177956_o() + hiveMin) {
                        this.aiPlaceBlock.setMetadata(0);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("propolis"), new BlockPos(hivePos.func_177958_n(), endY, hivePos.func_177952_p()));
                    }
                } else if (direction == 3) {
                    y = endY = hivePos.func_177956_o() - hiveMinFloor;
                    while (y >= hivePos.func_177956_o() - hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) {
                        endY = y--;
                    }
                    if (endY <= hivePos.func_177956_o() - hiveMin) {
                        this.aiPlaceBlock.setMetadata(1);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("propolis"), new BlockPos(hivePos.func_177958_n(), endY, hivePos.func_177952_p()));
                    }
                }
                if (direction == 4) {
                    z = endZ = hivePos.func_177952_p() + hiveMin;
                    while (z <= hivePos.func_177952_p() + hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) {
                        endZ = z++;
                    }
                    if (endZ >= hivePos.func_177952_p() + hiveMin) {
                        this.aiPlaceBlock.setMetadata(2);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax"), new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), endZ));
                    }
                } else if (direction == 5) {
                    z = endZ = hivePos.func_177952_p() - hiveMin;
                    while (z >= hivePos.func_177952_p() - hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) {
                        endZ = z--;
                    }
                    if (endZ <= hivePos.func_177952_p() - hiveMin) {
                        this.aiPlaceBlock.setMetadata(3);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax"), new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), endZ));
                    }
                }
            } else {
                List<EntityVespidQueen.HiveExposedCoordinates> hiveExposedCoordsList = queen.getHiveExposureBlocks();
                if (hiveExposedCoordsList.size() > 0) {
                    EntityVespidQueen.HiveExposedCoordinates hiveExposedCoords = hiveExposedCoordsList.size() > 1 ? hiveExposedCoordsList.get(this.func_70681_au().nextInt(hiveExposedCoordsList.size())) : hiveExposedCoordsList.get(0);
                    this.aiPlaceBlock.setMetadata(hiveExposedCoords.orientationMeta);
                    this.aiPlaceBlock.setBlockPlacement(hiveExposedCoords.block, hiveExposedCoords.pos);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() instanceof EntityConba && ((EntityConba)this.func_70638_az()).vespidInfection) {
            this.func_70624_b(null);
        }
    }

    public boolean isHiveBlock(BlockPos searchPos) {
        return this.isHiveWall(searchPos) || this.isHiveFloor(searchPos);
    }

    public boolean isHiveWall(BlockPos searchPos) {
        IBlockState searchState = this.field_70170_p.func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock != null && searchBlock == ObjectManager.getBlock("veswax") && searchBlock.func_176201_c(searchState) < 8;
    }

    public boolean isHiveFloor(BlockPos searchPos) {
        IBlockState searchState = this.field_70170_p.func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock != null && searchBlock == ObjectManager.getBlock("veswax") && searchBlock.func_176201_c(searchState) < 8;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            int effectSeconds = 8;
            if (target instanceof EntityPlayer) {
                effectSeconds = (byte)(effectSeconds / 2);
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.getEffectDuration(effectSeconds), 0));
        }
        return true;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity == this.getMasterTarget()) {
            return false;
        }
        if (targetEntity instanceof EntityConba) {
            return !((EntityConba)targetEntity).vespidInfection;
        }
        if (targetEntity instanceof EntityVespid && (!((EntityVespid)targetEntity).hasMaster() || ((EntityVespid)targetEntity).getMasterTarget() == this.getMasterTarget())) {
            return false;
        }
        if (targetEntity instanceof EntityVespidQueen && (!this.hasMaster() || this.getMasterTarget() == targetEntity)) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76421_d) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }
}

