/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.forestmobs.entity;

import java.util.HashMap;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupFire;
import lycanite.lycanitesmobs.api.IGroupPlant;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackRanged;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowOwner;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerThreats;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import lycanite.lycanitesmobs.forestmobs.entity.EntityLifeDrain;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class EntitySpriggan
extends EntityCreatureTameable
implements IMob,
IGroupPlant {
    EntityAIAttackRanged rangedAttackAI;
    public int farmingRate = 20;
    private int farmingTick = 0;
    EntityLifeDrain projectile = null;

    public EntitySpriggan(World par1World) {
        super(par1World);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 10;
        this.hasAttackSound = false;
        this.setWidth = 0.8f;
        this.setHeight = 1.2f;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.farmingRate = ConfigBase.getConfig(this.group, "general").getInt("Features", "Spriggan Minion Crop Boosting", this.farmingRate, "Sets the rate in ticks (20 ticks = 1 second) that a Spriggan will boost nearby crops. Each boost will usually cause the crop to grow one stage.");
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.rangedAttackAI = new EntityAIAttackRanged(this).setSpeed(0.75).setRate(10).setStaminaTime(100).setRange(8.0f).setMinChaseDistance(4.0f);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.rangedAttackAI);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupFire.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 15.0);
        baseAttributes.put("movementSpeed", 0.2);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151055_y), 0.5f).setMaxAmount(6).setBurningDrop(new ItemStack(Items.field_151044_h, 1, 1)));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150395_bd), 0.1f).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Items.field_151014_N), 0.1f).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Items.field_151080_bb), 0.05f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(Items.field_151081_bc), 0.05f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("lifedraincharge")), 0.25f).setMaxAmount(1));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 2));
        } else if (this.field_70170_p.func_72896_J() && this.field_70170_p.func_175710_j(this.func_180425_c())) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 1));
        }
        int currentFarmingRate = this.farmingRate;
        if (this.isTamed() && currentFarmingRate > 0) {
            if (this.isPetType("familiar")) {
                currentFarmingRate = this.farmingRate * 10;
            }
            if (this.subspecies != null) {
                currentFarmingRate = Math.max(1, Math.round((float)this.farmingRate / 3.0f));
            }
            ++this.farmingTick;
            int farmingRange = 16;
            int farmingHeight = 4;
            for (int x = (int)this.field_70165_t - farmingRange; x <= (int)this.field_70165_t + farmingRange; ++x) {
                for (int y = (int)this.field_70163_u - farmingHeight; y <= (int)this.field_70163_u + farmingHeight; ++y) {
                    for (int z = (int)this.field_70161_v - farmingRange; z <= (int)this.field_70161_v + farmingRange; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block farmingBlock = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (farmingBlock == null || !(farmingBlock instanceof IPlantable) || !(farmingBlock instanceof IGrowable) || farmingBlock == Blocks.field_150329_H || farmingBlock == Blocks.field_150398_cm) continue;
                        if (!this.field_70170_p.field_72995_K && this.farmingTick % currentFarmingRate == 0 && farmingBlock.func_149653_t()) {
                            this.field_70170_p.func_180497_b(pos, farmingBlock, currentFarmingRate, 1);
                        }
                        if (!this.field_70170_p.field_72995_K || this.farmingTick % 40 != 0) continue;
                        double d0 = this.func_70681_au().nextGaussian() * 0.02;
                        double d1 = this.func_70681_au().nextGaussian() * 0.02;
                        double d2 = this.func_70681_au().nextGaussian() * 0.02;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)((float)x + this.func_70681_au().nextFloat()), (double)y + (double)this.func_70681_au().nextFloat(), (double)((float)z + this.func_70681_au().nextFloat()), d0, d1, d2, new int[0]);
                    }
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                int[] nArray = new int[1];
                nArray[0] = BlockTallGrass.func_176210_f((IBlockState)Blocks.field_150329_H.func_176223_P());
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, nArray);
            }
        }
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        if (this.projectile != null && this.projectile.func_70089_S()) {
            this.projectile.setTime(20);
        } else {
            this.projectile = null;
        }
        if (this.projectile == null) {
            this.projectile = new EntityLifeDrain(this.field_70170_p, (EntityLivingBase)this, 25, 20);
            this.projectile.setBaseDamage(1);
            this.func_184185_a(this.projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)this.projectile);
        }
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        if (damageSrc.func_76346_g() != null) {
            EntityLiving entityLiving;
            Item heldItem = null;
            if (damageSrc.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)damageSrc.func_76346_g();
                if (entityPlayer.func_184586_b(EnumHand.MAIN_HAND) != null) {
                    heldItem = entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
                }
            } else if (damageSrc.func_76346_g() instanceof EntityLiving && (entityLiving = (EntityLiving)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND) != null) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            }
            if (ObjectLists.isAxe(heldItem)) {
                return 4.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76421_d) {
            return false;
        }
        if (ObjectManager.getPotionEffect("paralysis") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("paralysis")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }
}

