/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.desertmobs.model;

import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.model.ModelCustomObj;
import lycanite.lycanitesmobs.desertmobs.DesertMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelClink
extends ModelCustomObj {
    float maxLeg = 0.0f;

    public ModelClink() {
        this(1.0f);
    }

    public ModelClink(float shadowSize) {
        this.initModel("Clink", DesertMobs.group, "entity/clink");
        this.setPartCenters(0.0f, 1.5f, 0.2f, "head", "mouth");
        this.setPartSubCenter("mouth", 0.0f, 1.475f, 0.45f);
        this.setPartCenter("body", 0.0f, 1.5f, 0.2f);
        this.setPartCenter("leftarm", 0.55f, 1.5f, 0.15f);
        this.setPartCenter("rightarm", -0.55f, 1.5f, 0.15f);
        this.setPartCenter("leftleg", 0.3f, 0.75f, -0.25f);
        this.setPartCenter("rightleg", -0.3f, 0.75f, -0.25f);
        this.setPartCenters(0.0f, 0.9f, -0.4f, "tail01", "tail02", "tail03", "tail04", "tail05");
        this.setPartSubCenter("tail02", 0.0f, 1.1f, -0.8f);
        this.setPartSubCenter("tail03", 0.0f, 1.55f, -0.9f);
        this.setPartSubCenter("tail04", 0.0f, 0.8f, -0.65f);
        this.setPartSubCenter("tail05", 0.0f, 2.0f, -0.8f);
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouth")) {
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
        }
        if (partName.equals("mouth")) {
            this.subCenterPart("mouth");
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f)), 0.0f, 0.0f);
            this.unsubCenterPart("mouth");
        }
        if (partName.equals("leftarm")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("rightarm")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        float walkSwing = 0.6f;
        if (partName.equals("leftarm")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 2.0f * distance * 0.5f));
        }
        if (partName.equals("rightarm")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 2.0f * distance * 0.5f));
        }
        if (partName.equals("leftleg")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.4f * distance));
        }
        if (partName.equals("rightleg")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.4f * distance));
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
            if (partName.equals("mouth")) {
                this.subCenterPart("mouth");
                this.rotate(30.0f, 0.0f, 0.0f);
                this.unsubCenterPart("mouth");
            }
            if (partName.equals("rightarm")) {
                angleX = -0.2f;
                angleZ = 0.0f;
                if (((EntityCreatureBase)entity).getAttackPhase() == 2) {
                    angleY = 0.2f;
                    rotation = 85.0f;
                } else if (((EntityCreatureBase)entity).getAttackPhase() == 3) {
                    angleY = 0.7f;
                    angleZ = -0.1f;
                    rotation = 40.0f;
                } else {
                    angleY = 0.5f;
                    rotation = 85.0f;
                }
            }
        }
        if (partName.equals("tail01") || partName.equals("tail02") || partName.equals("tail03") || partName.equals("tail04") || partName.equals("tail05")) {
            rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

