/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.spawning;

import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.spawning.CustomSpawner;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnTypeBlockBreak
extends SpawnTypeBase {
    public boolean playerOnly = false;

    public SpawnTypeBlockBreak(String typeName) {
        super(typeName);
        CustomSpawner.instance.blockSpawnTypes.add(this);
    }

    @Override
    public void loadFromConfig() {
        super.loadFromConfig();
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        this.playerOnly = config.getBool("Spawner Features", this.getCfgName("Player Only"), this.playerOnly, "If true, this spawn type will only react to blocks broken by actual player (for example this will stop BuildCraft Quarries from spawning Geonach).");
    }

    public boolean spawnMobs(long tick, World world, BlockPos pos, EntityPlayer player, Block block) {
        boolean rare = this.isRareBlock(block);
        LycanitesMobs.printDebug("CustomSpawnerBlockBreak", this.typeName + ": A valid block was broken/harvested for this spawner." + (rare ? " (Rare)" : ""));
        return super.spawnMobs(tick, world, pos, player, rare);
    }

    public boolean validBlockBreak(Block block, World world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean validBlockHarvest(Block block, World world, BlockPos pos, Entity entity) {
        return !this.playerOnly || entity instanceof EntityPlayer;
    }

    public boolean isRareBlock(Block block) {
        return false;
    }
}

