/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.modelloader.obj;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import lycanite.lycanitesmobs.api.modelloader.obj.IndexedModel;
import lycanite.lycanitesmobs.api.modelloader.obj.Mesh;
import lycanite.lycanitesmobs.api.modelloader.obj.Model;
import lycanite.lycanitesmobs.api.modelloader.obj.OBJLoader;
import lycanite.lycanitesmobs.api.modelloader.obj.ObjEvent;
import lycanite.lycanitesmobs.api.modelloader.obj.ObjModel;
import lycanite.lycanitesmobs.api.modelloader.obj.ObjObject;
import lycanite.lycanitesmobs.api.modelloader.obj.TessellatorModelEvent;
import lycanite.lycanitesmobs.api.modelloader.obj.Vertex;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public class TessellatorModel
extends ObjModel {
    public static final EventBus MODEL_RENDERING_BUS = new EventBus();

    public TessellatorModel(ResourceLocation resource) throws IOException {
        this(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b().toString());
    }

    public TessellatorModel(String string) {
        super(string);
        try {
            String content = new String(this.read(Model.class.getResourceAsStream(string)), "UTF-8");
            String startPath = string.substring(0, string.lastIndexOf(47) + 1);
            HashMap<ObjObject, IndexedModel> map = new OBJLoader().loadModel(startPath, content);
            this.objObjects.clear();
            Set<ObjObject> keys = map.keySet();
            for (ObjObject object : keys) {
                Mesh mesh;
                object.mesh = mesh = new Mesh();
                this.objObjects.add(object);
                map.get(object).toMesh(mesh);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void renderImpl() {
        Collections.sort(this.objObjects, new Comparator<ObjObject>(){

            @Override
            public int compare(ObjObject a, ObjObject b) {
                Vec3d v = Minecraft.func_71410_x().func_175606_aa().func_174791_d();
                double aDist = v.func_72438_d(new Vec3d((double)a.center.x, (double)a.center.y, (double)a.center.z));
                double bDist = v.func_72438_d(new Vec3d((double)b.center.x, (double)b.center.y, (double)b.center.z));
                return Double.compare(aDist, bDist);
            }
        });
        for (ObjObject object : this.objObjects) {
            this.renderGroup(object);
        }
    }

    @Override
    public void renderGroupsImpl(String group) {
        for (ObjObject object : this.objObjects) {
            if (!object.getName().equals(group)) continue;
            this.renderGroup(object);
        }
    }

    @Override
    public void renderGroupImpl(ObjObject obj, Vector4f color) {
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tess.func_178180_c();
        if (obj.mesh == null) {
            return;
        }
        int[] indices = obj.mesh.indices;
        Vertex[] vertices = obj.mesh.vertices;
        vertexBuffer.func_181668_a(4, DefaultVertexFormats.field_181712_l);
        for (int i = 0; i < indices.length; i += 3) {
            Vector3f normal = this.getNormal(vertices[indices[i]].getPos(), vertices[indices[i + 1]].getPos(), vertices[indices[i + 2]].getPos());
            for (int iv = 0; iv < 3; ++iv) {
                Vertex v = vertices[indices[i + iv]];
                vertexBuffer.func_181662_b((double)v.getPos().x, (double)v.getPos().y, (double)v.getPos().z).func_187315_a((double)v.getTexCoords().x, (double)(1.0f - v.getTexCoords().y)).func_181666_a(color.x, color.y, color.z, color.w).func_181663_c(normal.x, normal.y, normal.z).func_181675_d();
            }
        }
        tess.func_78381_a();
    }

    public Vector3f getNormal(Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f output = new Vector3f();
        Vector3f calU = new Vector3f(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        Vector3f calV = new Vector3f(p3.x - p1.x, p3.y - p1.y, p3.z - p1.z);
        output.x = calU.y * calV.z - calU.z * calV.y;
        output.y = calU.z * calV.x - calU.x * calV.z;
        output.z = calU.x * calV.y - calU.y * calV.x;
        output.normalize();
        return output;
    }

    @Override
    public boolean fireEvent(ObjEvent event) {
        TessellatorModelEvent evt = null;
        if (event.type == ObjEvent.EventType.PRE_RENDER_GROUP) {
            evt = new TessellatorModelEvent.RenderGroupEvent.Pre(((ObjObject)event.data[1]).getName(), this);
        } else if (event.type == ObjEvent.EventType.POST_RENDER_GROUP) {
            evt = new TessellatorModelEvent.RenderGroupEvent.Post(((ObjObject)event.data[1]).getName(), this);
        } else if (event.type == ObjEvent.EventType.PRE_RENDER_ALL) {
            evt = new TessellatorModelEvent.RenderPre(this);
        } else if (event.type == ObjEvent.EventType.POST_RENDER_ALL) {
            evt = new TessellatorModelEvent.RenderPost(this);
        }
        if (evt != null) {
            return !MODEL_RENDERING_BUS.post((Event)evt);
        }
        return true;
    }
}

