/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.mobevent;

import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.mobevent.MobEventBoss;
import lycanite.lycanitesmobs.api.mobevent.MobEventServer;
import net.minecraft.world.World;

public class MobEventServerBoss
extends MobEventServer {
    public MobEventBoss mobEventBoss;
    public int originX = 0;
    public int originY = 0;
    public int originZ = 0;

    public MobEventServerBoss(MobEventBoss mobEventBoss, World world) {
        super(mobEventBoss, world);
        this.mobEventBoss = mobEventBoss;
    }

    @Override
    public void onStart() {
        this.mobEvent.onStart(this.world);
        this.startedWorldTime = this.world.func_82737_E();
        this.ticks = 0;
        LycanitesMobs.printInfo("", "Boss Event Started: " + this.mobEvent.getTitle() + " In Dimension: " + this.world.field_73011_w.getDimension() + " Intro Duration: " + this.mobEvent.duration / 20 + "secs");
    }

    @Override
    public void changeStartedWorldTime(long newStartedTime) {
        this.startedWorldTime = newStartedTime;
        LycanitesMobs.printInfo("", "Boss Event Start Time Changed: " + this.mobEvent.getTitle() + " In Dimension: " + this.world.field_73011_w.getDimension() + " Intro Duration: " + this.mobEvent.duration / 20 + "secs" + " Time Remaining: " + ((long)this.mobEvent.duration - (this.world.func_82737_E() - this.startedWorldTime)) / 20L + "secs");
    }

    @Override
    public void onFinish() {
        this.mobEvent.onFinish(this.world);
        LycanitesMobs.printInfo("", "Mob Event Finished: " + this.mobEvent.getTitle());
    }

    @Override
    public void onUpdate() {
        if (this.world == null) {
            LycanitesMobs.printWarning("", "MobEventServerBoss was trying to update without a world object, stopped!");
            return;
        }
        if (this.world.field_72995_K) {
            LycanitesMobs.printWarning("", "MobEventServerBoss was trying to update with a client side world, stopped!");
            return;
        }
        this.mobEventBoss.bossSetup(this.ticks, this.world, this.originX, this.originY, this.originZ);
        ++this.ticks;
        if (this.world.func_82737_E() >= this.startedWorldTime + (long)this.mobEvent.duration) {
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(this.world);
            worldExt.stopMobEvent(this);
        }
    }
}

