/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.mobevent;

import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.mobevent.MobEventBase;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class MobEventServer {
    public static boolean testOnCreative = false;
    public MobEventBase mobEvent;
    public int ticks = 0;
    public World world;
    public long startedWorldTime = 0L;

    public MobEventServer(MobEventBase mobEvent, World world) {
        this.mobEvent = mobEvent;
        this.world = world;
        if (world.field_72995_K) {
            LycanitesMobs.printWarning("", "Created a MobEventServer with a client side world, this shouldn't happen, things are going to get weird!");
        }
    }

    public void onStart() {
        this.mobEvent.onStart(this.world);
        boolean extended = false;
        if (this.world != null && this.world.func_82737_E() < this.startedWorldTime + (long)this.mobEvent.duration) {
            extended = true;
        }
        this.startedWorldTime = this.world.func_82737_E();
        this.ticks = 0;
        LycanitesMobs.printInfo("", "Mob Event " + (extended ? "Extended" : "Started") + ": " + this.mobEvent.getTitle() + " In Dimension: " + this.world.field_73011_w.getDimension() + " Duration: " + this.mobEvent.duration / 20 + "secs");
    }

    public void changeStartedWorldTime(long newStartedTime) {
        this.startedWorldTime = newStartedTime;
        LycanitesMobs.printInfo("", "Mob Event Start Time Changed: " + this.mobEvent.getTitle() + " In Dimension: " + this.world.field_73011_w.getDimension() + " Duration: " + this.mobEvent.duration / 20 + "secs" + " Time Remaining: " + ((long)this.mobEvent.duration - (this.world.func_82737_E() - this.startedWorldTime)) / 20L + "secs");
    }

    public void onFinish() {
        this.mobEvent.onFinish(this.world);
        LycanitesMobs.printInfo("", "Mob Event Finished: " + this.mobEvent.getTitle());
    }

    public void onUpdate() {
        if (this.world == null) {
            LycanitesMobs.printWarning("", "MobEventBase was trying to update without a world object, stopped!");
            return;
        }
        if (this.world.field_72995_K) {
            LycanitesMobs.printWarning("", "MobEventBase was trying to update with a client side world, stopped!");
            return;
        }
        for (Object playerObj : this.world.field_73010_i) {
            if (!(playerObj instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)playerObj;
            if (player.field_71075_bZ.field_75098_d && !testOnCreative) continue;
            int tickOffset = 0;
            for (SpawnTypeBase spawnType : this.mobEvent.spawners) {
                spawnType.spawnMobs(this.ticks - tickOffset, this.world, player.func_180425_c(), player);
                tickOffset += 7;
            }
        }
        ++this.ticks;
        if (this.world.func_82737_E() >= this.startedWorldTime + (long)this.mobEvent.duration) {
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(this.world);
            worldExt.stopWorldEvent();
        }
    }
}

