/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.config.ConfigSpawning;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class SpawnInfo {
    public static double spawnLimitRange = 32.0;
    public static boolean disableAllSpawning = false;
    public static boolean disableDungeonSpawners = false;
    public static boolean enforceBlockCost = true;
    public static boolean useSurfaceLightLevel = true;
    public static double spawnWeightScale = 1.0;
    public static double dungeonSpawnerWeightScale = 1.0;
    public static boolean ignoreWorldGenSpawning = false;
    public MobInfo mobInfo;
    public boolean enabled = true;
    public String spawnTypeEntries = "";
    public SpawnTypeBase[] spawnTypes = new SpawnTypeBase[0];
    public EnumCreatureType[] creatureTypes = new EnumCreatureType[0];
    public String dimensionEntries = "GROUP";
    public int[] dimensionBlacklist;
    public String[] dimensionTypes;
    public boolean dimensionWhitelist = false;
    public String biomeEntries = "GROUP";
    public BiomeGenBase[] biomes;
    public boolean ignoreBiome = false;
    public int spawnWeight = 8;
    public double spawnChance = 1.0;
    public int dungeonWeight = 200;
    public int spawnAreaLimit = 5;
    public int spawnGroupMin = 1;
    public int spawnGroupMax = 3;
    public int spawnBlockCost = 1;
    public boolean spawnsInLight = false;
    public boolean spawnsInDark = true;
    public boolean despawnNatural = true;
    public boolean despawnForced = false;

    public static void loadGlobalSettings() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "spawning");
        config.setCategoryComment("Global Spawning", "These settings are used by everything. It is recommended to leave them as they are however low end machines might benefit from a few tweaks here.");
        spawnLimitRange = config.getDouble("Global Spawning", "Mob Limit Search Range", spawnLimitRange, "How far a mob should search from in blocks when checking how many of its kind have already spawned.");
        disableAllSpawning = config.getBool("Global Spawning", "Disable Spawning", disableAllSpawning, "If true, all mobs from this mod will not spawn at all.");
        enforceBlockCost = config.getBool("Global Spawning", "Enforce Block Costs", enforceBlockCost, "If true, mobs will double check if their required blocks are nearby, such as Cinders needing so many blocks of fire.");
        spawnWeightScale = config.getDouble("Global Spawning", "Weight Scale", spawnWeightScale, "Scales the spawn weights of all mobs from this mod. For example, you can use this to quickly half the spawn rates of mobs from this mod compared to vanilla/other mod mobs by setting it to 0.5.");
        useSurfaceLightLevel = config.getBool("Global Spawning", "Use Surface Light Level", useSurfaceLightLevel, "If true, when water mobs spawn, instead of checking the light level of the block the mob is spawning at, the light level of the surface (if possible) is checked. This stops mobs like Jengus from spawning at the bottom of deep rivers during the day, set to false for the old way.");
        ignoreWorldGenSpawning = config.getBool("Global Spawning", "Ignore WorldGen Spawning", ignoreWorldGenSpawning, "If true, when new world chunks are generated, no mobs from this mod will pre-spawn (mobs will still attempt to spawn randomly afterwards). Set this to true if you are removing mobs from vanilla dimensions as the vanilla WorldGen spawning ignores mob spawn conditions.");
        config.setCategoryComment("Dungeon Features", "Here you can set special features used in dungeon generation.");
        disableDungeonSpawners = config.getBool("Dungeon Features", "Disable Dungeon Spawners", disableDungeonSpawners, "If true, newly generated dungeons wont create spawners with mobs from this mod.");
        dungeonSpawnerWeightScale = config.getDouble("Dungeon Features", "Dungeon Spawner Weight Scale", dungeonSpawnerWeightScale, "Scales the weight of dungeons using spawners from this mod. For example, you can half the chances all dungeons having spawners with mobs from this mod in them by setting this to 0.5.");
    }

    public SpawnInfo(MobInfo setMobInfo) {
        this.mobInfo = setMobInfo;
    }

    public void loadFromConfig() {
        if (this.mobInfo.dummy) {
            return;
        }
        ConfigSpawning config = ConfigSpawning.getConfig(this.mobInfo.group, "spawning");
        config.setCategoryComment("Enabled Spawns", "Set to false to prevent mobs from spawning naturally at all.");
        this.enabled = config.getBool("Enabled Spawns", this.getCfgName("Spawning Enabled"), this.enabled);
        if (!this.enabled) {
            return;
        }
        config.setCategoryComment("Spawn Types", "Specifies how this mob spawns, multiple entries should be comma separated. Valid types are: MONSTER, CREATURE, WATERCREATURE, FIRE, FROSTFIRE, LAVA, ROCK, STORM. More will likely be added too.");
        ConfigSpawning.SpawnTypeSet spawnTypeSet = config.getTypes("Spawn Types", this.getCfgName("Spawn Types"), this.spawnTypeEntries);
        this.spawnTypes = spawnTypeSet.spawnTypes;
        this.creatureTypes = spawnTypeSet.creatureTypes;
        config.setCategoryComment("Spawn Dimensions", "Sets which dimensions (by ID) that mobs WILL NOT spawn in. However if 'Spawn Dimensions Whitelist Mode' is set to true, it will instead set which dimensions they WILL ONLY spawn in. You may enter dimension IDs and/or GROUP to use the group settings. Multiple entries should be comma separated. Note that some Spawn Types ignore this such as the PORTAL type.");
        ConfigSpawning.SpawnDimensionSet spawnDimensions = config.getDimensions("Spawn Dimensions", this.getCfgName("Spawn Dimensions"), this.dimensionEntries);
        this.dimensionBlacklist = spawnDimensions.dimensionIDs;
        this.dimensionTypes = spawnDimensions.dimensionTypes;
        this.dimensionWhitelist = config.getBool("Spawn Dimensions", this.getCfgName("Spawn Dimensions Whitelist Mode"), this.dimensionWhitelist);
        config.setCategoryComment("Spawn Biomes", "Sets which biomes this mob spawns in using Biome Tags. Multiple entries should be comma separated and can be subtractive if provided with a - in front. You can also have a mob skip the biome check completely if ALL is not working correctly for modded biomes.");
        this.biomes = config.getBiomes("Spawn Biomes", this.getCfgName("Spawn Biomes"), this.biomeEntries);
        this.ignoreBiome = config.getBool("Spawn Biomes", this.getCfgName("Spawn Ignores Biome Check"), this.ignoreBiome);
        config.setCategoryComment("Spawn Weights", "The higher the weight, the more likely the mob will spawn randomly instead of others. Vanilla Zombies have a weight of 8.");
        this.spawnWeight = Math.round((float)config.getDouble("Spawn Weights", this.getCfgName("Spawn Weight"), this.spawnWeight) * (float)spawnWeightScale);
        config.setCategoryComment("Spawn Chances", "Adds a forced spawn fail chance. A chance of 1.0 (100%) means that the mob will always spawn. A chance of 0.5 means it will have a 50% chance of spawning. Use this as a last resort as a failed spawn still takes up a spawning oppotunity.");
        this.spawnChance = config.getDouble("Spawn Chances", this.getCfgName("Spawn Chance"), this.spawnChance);
        config.setCategoryComment("Dungeon Weights", "The higher the weight, the more likely this mob will appear in random dungeon spawners. Vanilla Zombie have a dungeon weight of 200.");
        this.dungeonWeight = Math.round((float)config.getDouble("Dungeon Weights", this.getCfgName("Dungeon Weight"), this.dungeonWeight) * (float)dungeonSpawnerWeightScale);
        config.setCategoryComment("Area limits", "Sets how many of each mob is allowed to naturally spawn near each other.");
        this.spawnAreaLimit = config.getInt("Area limits", this.getCfgName("Area Limit"), this.spawnAreaLimit);
        config.setCategoryComment("Group Sizes", "Sets the minimum and maximum random size of a group spawned. Note with the vanilla spawn, large groups can reduce the spawning odds in biomes with lots trees, etc.");
        this.spawnGroupMin = config.getInt("Group Sizes", this.getCfgName("Group Min"), this.spawnGroupMin);
        this.spawnGroupMax = config.getInt("Group Sizes", this.getCfgName("Group Max"), this.spawnGroupMax);
        config.setCategoryComment("Block Costs", "Only used by certain spawners. Sets how many blocks are required for spawning, such as how many blocks of Fire a Cinder requires.");
        this.spawnBlockCost = config.getInt("Block Costs", this.getCfgName("Block Cost"), this.spawnBlockCost);
        config.setCategoryComment("Spawn Conditions", "Various conditions that are checked at a spawn location when spawning mobs, such as light level.");
        this.spawnsInLight = config.getBool("Spawn Conditions", this.getCfgName("Spawns In Light"), this.spawnsInLight);
        this.spawnsInDark = config.getBool("Spawn Conditions", this.getCfgName("Spawns In Dark"), this.spawnsInDark);
        config.setCategoryComment("Despawning", "Sets whether or not each mob will despawn over time. Most farmable mobs don't despawn naturally.");
        this.despawnNatural = config.getBool("Despawning", this.getCfgName("Natural Despawning"), this.despawnNatural);
        config.setCategoryComment("Despawning", "Forces a mob to despawn naturally (unless tamed). Some farmable mobs such as Pinkies ignore their Natural Despawning setting once they've been fed or moved out of their home dimension.");
        this.despawnForced = config.getBool("Despawning", this.getCfgName("Forced Despawning"), this.despawnForced);
        this.registerSpawn();
    }

    /*
     * WARNING - void declaration
     */
    public void registerSpawn() {
        void var4_9;
        int n;
        SpawnTypeBase[] spawnTypeBaseArray;
        boolean spawnAdded = false;
        if (!disableAllSpawning && this.enabled && this.mobInfo.mobEnabled && this.spawnWeight > 0 && this.spawnGroupMax > 0) {
            void var4_7;
            spawnTypeBaseArray = this.creatureTypes;
            n = spawnTypeBaseArray.length;
            boolean bl = false;
            while (var4_7 < n) {
                SpawnTypeBase spawnTypeBase = spawnTypeBaseArray[var4_7];
                EntityRegistry.addSpawn((Class)this.mobInfo.entityClass, (int)this.spawnWeight, (int)(ignoreWorldGenSpawning ? 0 : this.spawnGroupMin), (int)(ignoreWorldGenSpawning ? 0 : this.spawnGroupMax), (EnumCreatureType)spawnTypeBase, (BiomeGenBase[])this.biomes);
                for (BiomeGenBase biome : this.biomes) {
                    if (biome != BiomeGenBase.field_185377_q.func_82594_a((Object)new ResourceLocation("hell"))) continue;
                    EntityRegistry.addSpawn((Class)this.mobInfo.entityClass, (int)(this.spawnWeight * 10), (int)(ignoreWorldGenSpawning ? 0 : this.spawnGroupMin), (int)(ignoreWorldGenSpawning ? 0 : this.spawnGroupMax), (EnumCreatureType)spawnTypeBase, (BiomeGenBase[])new BiomeGenBase[]{biome});
                    break;
                }
                ++var4_7;
            }
            spawnAdded = true;
        }
        spawnTypeBaseArray = this.spawnTypes;
        n = spawnTypeBaseArray.length;
        boolean bl = false;
        while (var4_9 < n) {
            SpawnTypeBase spawnTypeBase = spawnTypeBaseArray[var4_9];
            spawnTypeBase.addSpawn(this.mobInfo);
            ++var4_9;
        }
        if (spawnAdded) {
            void var4_13;
            void var4_11;
            LycanitesMobs.printDebug("MobSetup", "Mob Spawn Added - Weight: " + this.spawnWeight + " Min: " + this.spawnGroupMin + " Max: " + this.spawnGroupMax);
            spawnTypeBaseArray = this.creatureTypes;
            n = spawnTypeBaseArray.length;
            boolean bl2 = false;
            while (var4_11 < n) {
                SpawnTypeBase spawnTypeBase = spawnTypeBaseArray[var4_11];
                LycanitesMobs.printDebug("MobSetup", "Vanilla Spawn Type: " + spawnTypeBase);
                ++var4_11;
            }
            spawnTypeBaseArray = this.spawnTypes;
            n = spawnTypeBaseArray.length;
            boolean bl3 = false;
            while (var4_13 < n) {
                SpawnTypeBase spawnTypeBase = spawnTypeBaseArray[var4_13];
                LycanitesMobs.printDebug("MobSetup", "Custom Spawn Type: " + spawnTypeBase != null ? spawnTypeBase.typeName : "NULL");
                ++var4_13;
            }
            String biomesList = "";
            if (LycanitesMobs.config.getBool("Debug", "MobSetup")) {
                void var5_25;
                BiomeGenBase[] biomeGenBaseArray = this.biomes;
                int n2 = biomeGenBaseArray.length;
                boolean bl4 = false;
                while (var5_25 < n2) {
                    BiomeGenBase biome = biomeGenBaseArray[var5_25];
                    if (!"".equals(biomesList)) {
                        biomesList = biomesList + ", ";
                    }
                    biomesList = biomesList + biome.func_185359_l();
                    ++var5_25;
                }
            }
            LycanitesMobs.printDebug("MobSetup", "Biomes: " + biomesList);
            String dimensionsList = "";
            int[] nArray = this.dimensionBlacklist;
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                int dimensionID = nArray[i];
                if (!"".equals(dimensionsList)) {
                    dimensionsList = dimensionsList + ", ";
                }
                dimensionsList = dimensionsList + Integer.toString(dimensionID);
            }
            for (String dimensionType : this.dimensionTypes) {
                if (!"".equals(dimensionsList)) {
                    dimensionsList = dimensionsList + ", ";
                }
                dimensionsList = dimensionsList + dimensionType;
            }
            LycanitesMobs.printDebug("MobSetup", "Dimensions (" + (this.dimensionWhitelist ? "Whitelist" : "Blacklist") + "): " + dimensionsList);
        } else {
            LycanitesMobs.printDebug("MobSetup", "Mob Spawn Not Added: The spawning of this mob (or all mobs) must be disabled or this mobs spawn weight or max group size is 0 or this mob is all together disabled.");
        }
        if (!disableDungeonSpawners && this.dungeonWeight > 0) {
            DungeonHooks.addDungeonMob((String)this.mobInfo.getRegistryName(), (int)this.dungeonWeight);
            LycanitesMobs.printDebug("MobSetup", "Dungeon Spawn Added - Weight: " + this.dungeonWeight);
        }
    }

    public SpawnInfo setEnabled(boolean bool) {
        this.enabled = bool;
        return this;
    }

    public SpawnInfo setSpawnTypes(String string) {
        this.spawnTypeEntries = string;
        return this;
    }

    public SpawnInfo setDimensions(String string) {
        this.dimensionEntries = string;
        return this;
    }

    public SpawnInfo setDimensionWhitelist(boolean whitelist) {
        this.dimensionWhitelist = whitelist;
        return this;
    }

    public SpawnInfo setBiomes(String string) {
        this.biomeEntries = string;
        return this;
    }

    public SpawnInfo setSpawnWeight(int integer) {
        this.spawnWeight = integer;
        this.dungeonWeight = integer * 25;
        return this;
    }

    public SpawnInfo setSpawnChance(int integer) {
        this.spawnChance = integer;
        return this;
    }

    public SpawnInfo setDungeonWeight(int integer) {
        this.dungeonWeight = integer;
        return this;
    }

    public SpawnInfo setAreaLimit(int integer) {
        this.spawnAreaLimit = integer;
        return this;
    }

    public SpawnInfo setGroupLimits(int min, int max) {
        this.spawnGroupMin = min;
        this.spawnGroupMax = max;
        return this;
    }

    public SpawnInfo setBlockCost(int integer) {
        this.spawnBlockCost = integer;
        return this;
    }

    public SpawnInfo setLightDark(boolean spawnsInLight, boolean spawnsInDark) {
        this.spawnsInLight = spawnsInLight;
        this.spawnsInDark = spawnsInDark;
        return this;
    }

    public SpawnInfo setDespawn(boolean bool) {
        this.despawnNatural = bool;
        return this;
    }

    public String getCfgName(String configKey) {
        return this.mobInfo.getCfgName(configKey);
    }
}

