/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigSpawning;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.world.biome.BiomeGenBase;

public class GroupInfo {
    public static Map<String, GroupInfo> groups = new HashMap<String, GroupInfo>();
    public Object mod;
    public int order;
    public String name;
    public String filename;
    public String eggName = "spawnegg";
    public List<MobInfo> mobInfos = new ArrayList<MobInfo>();
    public int nextMobID = 0;
    public int nextProjectileID = 100;
    public List<Class> projectileClasses = new ArrayList<Class>();
    public List<Class> specialClasses = new ArrayList<Class>();
    public int achievementIDBase = 1000;
    public String dimensionEntries = "";
    public int[] dimensionBlacklist;
    public String[] dimensionTypes;
    public boolean dimensionWhitelist = false;
    public String biomeEntries = "";
    public BiomeGenBase[] biomes = new BiomeGenBase[0];
    public boolean controlVanillaSpawns = true;
    public String dungeonThemes = "";

    public static void loadAllSpawningFromConfigs() {
        for (GroupInfo group : groups.values()) {
            group.loadSpawningFromConfig();
        }
    }

    public GroupInfo(Object mod, String name, int order) {
        this.mod = mod;
        this.name = name;
        this.filename = name.toLowerCase().replace(" ", "");
        this.order = order;
        this.achievementIDBase = order * 10000;
        if (order < 100) {
            this.achievementIDBase += 10000;
        }
        groups.put(this.name, this);
    }

    public void loadFromConfig() {
        if ("lycanitesmobs".equalsIgnoreCase(this.filename)) {
            return;
        }
        ConfigSpawning config = ConfigSpawning.getConfig(this, "spawning");
        config.setCategoryComment("Group Settings", "Here you can set the spawning settings for all mobs in this group that use the GROUP tag.");
        config = ConfigSpawning.getConfig(this, "general");
        config.setCategoryComment("Vanilla Spawning", "Here you may control settings that affect vanilla Minecraft.");
        this.controlVanillaSpawns = config.getBool("Vanilla Spawning", "Edit Vanilla Spawning", true, "If true, some vanilla spawns in this group's biomes will be removed, note that vanilla mobs should still be easy to find, only they will be more biome specific.");
        this.dungeonThemes = config.getString("Group Settings", this.getCfgName("Themes"), this.dungeonThemes, "Here you can set the Dungeon Theme of this mob group. These are used by Doomlike Dungeons and might be used by other things later. Multiple entries should be comma seperated.");
    }

    public void loadSpawningFromConfig() {
        if ("lycanitesmobs".equalsIgnoreCase(this.filename)) {
            return;
        }
        ConfigSpawning config = ConfigSpawning.getConfig(this, "spawning");
        config.setCategoryComment("Group Settings", "Here you can set the spawning settings for all mobs in this group that use the GROUP tag.");
        ConfigSpawning.SpawnDimensionSet spawnDimensions = config.getDimensions("Group Settings", this.getCfgName("Spawn Dimensions"), this.dimensionEntries, "Sets which dimensions (by ID) that mobs WILL NOT spawn in. However if 'Spawn Dimensions Whitelist Mode' is set to true, it will instead set which dimensions they WILL ONLY spawn in. Multiple entries should be comma separated. Note that some Spawn Types ignore this such as the PORTAL type.");
        this.dimensionBlacklist = spawnDimensions.dimensionIDs;
        this.dimensionTypes = spawnDimensions.dimensionTypes;
        this.dimensionWhitelist = config.getBool("Group Settings", this.getCfgName("Spawn Dimensions Whitelist Mode"), this.dimensionWhitelist, "If true, the 'Spawn Dimensions' list will act as a whitelist instead of a blacklist.");
        this.biomes = config.getBiomes("Group Settings", this.getCfgName("Spawn Biomes"), this.biomeEntries, "Sets which biomes this mob spawns in using Biome Tags. Multiple entries should be comma separated and can be subtractive if provided with a - in front.");
    }

    public String getCfgName(String configKey) {
        return this.name + " " + configKey;
    }

    public int getNextMobID() {
        int id = this.nextMobID++;
        return id;
    }

    public int getNextProjectileID() {
        int id = this.nextProjectileID++;
        return id;
    }

    public String getEggName() {
        return this.eggName;
    }

    public int getAchievementID(int childID) {
        int baseID = this.achievementIDBase;
        if (this != LycanitesMobs.group) {
            baseID += LycanitesMobs.achievementGlobalBaseID * 10000;
        }
        return baseID + childID;
    }

    public GroupInfo setDimensionBlacklist(String string) {
        this.dimensionEntries = string;
        return this;
    }

    public GroupInfo setDimensionWhitelist(boolean bool) {
        this.dimensionWhitelist = bool;
        return this;
    }

    public GroupInfo setBiomes(String string) {
        this.biomeEntries = string;
        return this;
    }

    public GroupInfo setDungeonThemes(String string) {
        this.dungeonThemes = string;
        return this;
    }

    public GroupInfo setEggName(String eggName) {
        this.eggName = eggName;
        return this;
    }
}

