/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.gui;

import java.io.IOException;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.gui.GUIBaseScreen;
import lycanite.lycanitesmobs.api.gui.GUIButtonCreature;
import lycanite.lycanitesmobs.api.gui.GUIPetList;
import lycanite.lycanitesmobs.api.gui.GUITabMain;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.pets.PetEntry;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.lwjgl.opengl.GL11;

public class GUIBaseManager
extends GUIBaseScreen {
    public EntityPlayer player;
    public ExtendedPlayer playerExt;
    public String type;
    public PetEntry selectedPet;
    public SummonSet summonSet;
    public GuiScrollingList list;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;
    public static int tabButtonID = 55555;
    public int editSet;

    public GUIBaseManager(EntityPlayer player, String type) {
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
        this.type = type;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.windowWidth = 256;
        this.windowHeight = 172;
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.field_146294_l / 2 - this.windowWidth / 2;
        this.windowY = this.field_146295_m / 2 - this.windowHeight / 2;
        this.centerX = this.windowX + this.windowWidth / 2;
        this.centerY = this.windowY + this.windowHeight / 2;
        this.drawControls();
        this.initList();
    }

    public void initList() {
        if (this.hasPets()) {
            this.selectPet(this.playerExt.petManager.getEntry(this.type, 0));
        }
        int buttonSpacing = 2;
        int listWidth = this.windowWidth / 2 - buttonSpacing * 4;
        int listHeight = this.windowHeight - (39 + buttonSpacing) - 16;
        int listTop = this.windowY + 39 + buttonSpacing;
        int listBottom = listTop + listHeight;
        int listX = this.windowX + buttonSpacing * 2;
        this.list = new GUIPetList(this, this.playerExt, listWidth, listHeight, listTop, listBottom, listX);
        this.list.registerScrollButtons(this.field_146292_n, 51, 52);
    }

    public void func_73863_a(int x, int y, float f) {
        this.drawGuiContainerBackgroundLayer(x, y, f);
        this.updateControls();
        this.drawGuiContainerForegroundLayer(x, y, f);
        if (this.hasPets()) {
            this.list.drawScreen(x, y, f);
        }
        super.func_73863_a(x, y, f);
    }

    protected void drawGuiContainerForegroundLayer(int x, int y, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        if (!this.hasPets()) {
            this.getFontRenderer().func_78276_b(I18n.func_74838_a((String)("gui." + this.type + "manager.empty")), this.centerX - 24, this.windowY + 6, 0xFFFFFF);
            this.getFontRenderer().func_78279_b(I18n.func_74838_a((String)("gui." + this.type + "manager.info")), this.windowX + 16, this.windowY + 30, this.windowWidth - 32, 0xFFFFFF);
            return;
        }
        if (!this.hasSelectedPet()) {
            return;
        }
        this.getFontRenderer().func_78276_b(this.getTitle(), this.centerX - 24, this.windowY + 6, 0xFFFFFF);
        this.getFontRenderer().func_78276_b(this.getEnergyTitle(), this.windowX + 16, this.windowY + 20, 0xFFFFFF);
        if ((this.type.equalsIgnoreCase("pet") || this.type.equalsIgnoreCase("mount")) && this.selectedPet.releaseEntity) {
            this.getFontRenderer().func_78279_b(I18n.func_74838_a((String)"gui.pet.release.confirm"), this.centerX + 2, this.windowY + 41, this.windowWidth / 2 - 2, 0xFFFFFF);
        }
    }

    public String getTitle() {
        return I18n.func_74838_a((String)("gui." + this.type + "manager.name"));
    }

    public String getEnergyTitle() {
        return I18n.func_74838_a((String)"stat.spirit.name");
    }

    protected void drawGuiContainerBackgroundLayer(int x, int y, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(this.windowX, this.windowY, 0, 0, this.windowWidth, this.windowHeight);
        if (!this.hasPets()) {
            int recipeWidth = 108;
            int recipeHeight = 54;
            this.func_73729_b(this.centerX - recipeWidth / 2, this.windowY + this.windowHeight - recipeHeight - 16, 0, 256 - recipeHeight, recipeWidth, recipeHeight);
            return;
        }
        if (this.hasSelectedPet()) {
            this.drawEnergyBar();
            this.drawHealthBar();
        }
    }

    public void drawEnergyBar() {
        int energyBarWidth = 9;
        int energyBarHeight = 9;
        int energyBarX = this.windowX + 16;
        int energyBarY = this.windowY + 40 - energyBarHeight;
        int energyBarU = 256 - energyBarWidth;
        int energyBarV = 256 - energyBarHeight;
        for (int energyBarEnergyN = 1; energyBarEnergyN <= 10; ++energyBarEnergyN) {
            this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU, energyBarV, energyBarWidth, energyBarHeight);
            if (this.playerExt.spirit >= energyBarEnergyN * this.playerExt.spiritCharge) {
                this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU - energyBarWidth, energyBarV, energyBarWidth, energyBarHeight);
                continue;
            }
            if (this.playerExt.spirit + this.playerExt.spiritCharge <= energyBarEnergyN * this.playerExt.spiritCharge) continue;
            float spiritChargeScale = (float)(this.playerExt.spirit % this.playerExt.spiritCharge) / (float)this.playerExt.spiritCharge;
            this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU - energyBarWidth, energyBarV, Math.round((float)energyBarWidth * spiritChargeScale), energyBarHeight);
        }
        energyBarU -= energyBarWidth * 2;
        int spiritBarReservedN = 1;
        while (spiritBarReservedN * this.playerExt.spiritCharge <= this.playerExt.spiritReserved) {
            this.func_73729_b(energyBarX + energyBarWidth * 10 - energyBarWidth * spiritBarReservedN, energyBarY, energyBarU, energyBarV, energyBarWidth, energyBarHeight);
            ++spiritBarReservedN;
        }
    }

    public void drawHealthBar() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
        int barWidth = 80;
        int barHeight = 11;
        int barX = this.centerX + 2;
        int barY = this.windowY + 26;
        int barU = 144;
        int barV = 256 - barHeight * 2;
        this.func_73729_b(barX, barY, barU, barV, barWidth, barHeight);
        if (!this.selectedPet.isRespawning) {
            barWidth = Math.round((float)barWidth * (this.selectedPet.getHealth() / this.selectedPet.getMaxHealth()));
            barV += barHeight;
        } else {
            barWidth -= Math.round((float)barWidth * ((float)this.selectedPet.respawnTime / (float)this.selectedPet.respawnTimeMax));
            barV -= barHeight;
        }
        this.func_73729_b(barX, barY, barU, barV, barWidth, barHeight);
    }

    protected void drawControls() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = this.windowWidth / 4 - buttonSpacing * 2;
        int buttonHeight = 20;
        int buttonX = this.windowX + 6;
        int buttonY = this.windowY;
        this.field_146292_n.add(new GUITabMain(tabButtonID, buttonX, buttonY - 24));
        buttonX = this.centerX + buttonSpacing;
        int buttonXRight = buttonX + buttonWidth + buttonSpacing;
        buttonY = this.windowY + 39 + buttonSpacing;
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.SPAWNING.id, buttonX, buttonY, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.TELEPORT.id, buttonXRight, buttonY, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.SITTING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id, buttonXRight, buttonY, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.STANCE.id, buttonXRight, buttonY, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PVP.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.RELEASE.id, buttonXRight, buttonY, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton(101, buttonX, buttonY, buttonWidth, buttonHeight, I18n.func_74838_a((String)"common.yes")));
        this.field_146292_n.add(new GuiButton(102, buttonXRight, buttonY, buttonWidth, buttonHeight, I18n.func_74838_a((String)"common.no")));
    }

    public void updateControls() {
        for (Object buttonObj : this.field_146292_n) {
            if (!(buttonObj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)buttonObj;
            if (button instanceof GUITabMain) {
                button.field_146124_l = true;
                button.field_146125_m = true;
                continue;
            }
            if (!this.hasSelectedPet()) {
                button.field_146124_l = false;
                button.field_146125_m = false;
                continue;
            }
            this.updateButtons(button);
        }
    }

    public void updateButtons(GuiButton button) {
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SPAWNING.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.active") + ": " + (this.selectedPet.spawningActive ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.TELEPORT.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.teleport");
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.sitting") + ": " + (this.summonSet.getSitting() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id) {
            String string = button.field_146126_j = this.summonSet.getFollowing() ? I18n.func_74838_a((String)"gui.pet.follow") : I18n.func_74838_a((String)"gui.pet.wander");
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.passive") + ": " + (this.summonSet.getPassive() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
            String string = button.field_146126_j = this.summonSet.getAggressive() ? I18n.func_74838_a((String)"gui.pet.aggressive") : I18n.func_74838_a((String)"gui.pet.defensive");
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.pvp") + ": " + (this.summonSet.getPVP() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.RELEASE.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.release");
        }
        if (!this.selectedPet.releaseEntity) {
            if (button.field_146127_k < 100) {
                button.field_146124_l = true;
                button.field_146125_m = true;
            } else if (button.field_146127_k == 101 || button.field_146127_k == 102) {
                button.field_146124_l = false;
                button.field_146125_m = false;
            }
        } else if (button.field_146127_k < 100) {
            button.field_146124_l = false;
            button.field_146125_m = false;
        } else if (button.field_146127_k == 101 || button.field_146127_k == 102) {
            button.field_146124_l = true;
            button.field_146125_m = true;
        }
        if ("mount".equals(this.type) && button.field_146127_k >= EntityCreatureBase.GUI_COMMAND_ID.SITTING.id && button.field_146127_k <= EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
            button.field_146124_l = false;
            button.field_146125_m = false;
        }
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        if (!this.hasSelectedPet()) {
            super.func_146284_a(guiButton);
            return;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
            boolean bl = this.summonSet.sitting = !this.summonSet.sitting;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id) {
            boolean bl = this.summonSet.following = !this.summonSet.following;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
            boolean bl = this.summonSet.passive = !this.summonSet.passive;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
            boolean bl = this.summonSet.aggressive = !this.summonSet.aggressive;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
            boolean bl = this.summonSet.pvp = !this.summonSet.pvp;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.TELEPORT.id) {
            this.selectedPet.teleportEntity = true;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SPAWNING.id) {
            boolean bl = this.selectedPet.spawningActive = !this.selectedPet.spawningActive;
        }
        if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.RELEASE.id && !this.selectedPet.releaseEntity) {
            this.selectedPet.releaseEntity = true;
        }
        if (guiButton.field_146127_k == 101 && this.selectedPet.releaseEntity) {
            this.playerExt.sendPetEntryRemoveRequest(this.selectedPet);
        }
        if (guiButton.field_146127_k == 102) {
            this.selectPet(this.selectedPet);
        }
        if (guiButton.field_146127_k < 100) {
            this.sendCommandsToServer();
        }
        super.func_146284_a(guiButton);
    }

    public void sendCommandsToServer() {
        this.playerExt.sendPetEntryToServer(this.selectedPet);
    }

    public void selectPet(PetEntry petSelection) {
        this.selectedPet = petSelection;
        this.summonSet = this.selectedPet.summonSet;
        this.selectedPet.releaseEntity = false;
    }

    public PetEntry getSelectedPet() {
        return this.selectedPet;
    }

    public void selectMinion(String minionName) {
        this.summonSet.setSummonType(minionName);
        this.playerExt.sendSummonSetToServer((byte)this.editSet);
        for (Object buttonObj : this.field_146292_n) {
            MobInfo mobInfo;
            GuiButton button = (GuiButton)buttonObj;
            if (!(button instanceof GUIButtonCreature)) continue;
            if (button.field_146127_k != this.editSet + tabButtonID) continue;
            ((GUIButtonCreature)button).mobInfo = mobInfo = this.playerExt.getSummonSet(this.editSet).getMobInfo();
        }
    }

    public String getSelectedMinion() {
        return this.summonSet.summonType;
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == 1 || par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(par1, par2);
    }

    public boolean hasPets() {
        return this.playerExt.petManager.getEntryList(this.type) != null && this.playerExt.petManager.getEntryList(this.type).size() > 0;
    }

    public boolean hasSelectedPet() {
        return this.hasPets() && this.selectedPet != null;
    }

    protected ResourceLocation getTexture() {
        return AssetManager.getTexture("GUIPet");
    }
}

