/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity.navigate;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ArenaNode {
    public List<ArenaNode> adjacentNodes = new ArrayList<ArenaNode>();
    public World world;
    public BlockPos pos;

    public ArenaNode(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void addAdjacentNode(ArenaNode node) {
        if (node == null || this.adjacentNodes.contains(node)) {
            return;
        }
        this.adjacentNodes.add(node);
    }

    public ArenaNode getRandomAdjacentNode() {
        int adjacentNodesSize = this.adjacentNodes.size();
        if (adjacentNodesSize <= 0) {
            return null;
        }
        if (adjacentNodesSize == 1) {
            return this.adjacentNodes.get(0);
        }
        return this.adjacentNodes.get(this.world.field_73012_v.nextInt(adjacentNodesSize));
    }

    public ArenaNode getClosestAdjacentNode(BlockPos targetPos) {
        int adjacentNodesSize = this.adjacentNodes.size();
        if (adjacentNodesSize <= 0) {
            return null;
        }
        if (adjacentNodesSize == 1) {
            return this.adjacentNodes.get(0);
        }
        double smallestDistance = this.pos.func_177951_i((Vec3i)targetPos);
        ArenaNode closestNode = this;
        for (ArenaNode adjacentNode : this.adjacentNodes) {
            double distance = adjacentNode.pos.func_177951_i((Vec3i)targetPos);
            if (!(distance < smallestDistance)) continue;
            smallestDistance = distance;
            closestNode = adjacentNode;
        }
        return closestNode;
    }
}

