/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity.ai;

import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureRideable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class EntityAIAttackRanged
extends EntityAIBase {
    private final EntityCreatureBase host;
    private EntityLivingBase attackTarget;
    private int attackTime;
    private int attackTimeClose = 20;
    private int attackTimeFar = 20;
    private int attackStamina = 0;
    private int attackStaminaMax = 0;
    public boolean attackOnCooldown = false;
    private int staminaRecoverRate = 1;
    private int staminaDrainRate = 1;
    private double speed = 1.0;
    private int chaseTime;
    private int chaseTimeMax = -1;
    private float range = 6.0f;
    private float attackDistance = 5.0f;
    private float minChaseDistance = 3.0f;
    private float flyingHeight = 2.0f;
    private boolean longMemory = true;
    private boolean checkSight = true;
    private boolean mountedAttacking = true;
    public boolean enabled = true;

    public EntityAIAttackRanged(EntityCreatureBase setHost) {
        this.host = setHost;
        this.func_75248_a(3);
    }

    public EntityAIAttackRanged setSpeed(double setSpeed) {
        this.speed = setSpeed;
        return this;
    }

    public EntityAIAttackRanged setLongMemory(boolean setLongMemory) {
        this.longMemory = setLongMemory;
        return this;
    }

    public EntityAIAttackRanged setCheckSight(boolean setCheckSight) {
        this.checkSight = setCheckSight;
        return this;
    }

    public EntityAIAttackRanged setRateClose(int rate) {
        this.attackTimeClose = rate;
        return this;
    }

    public EntityAIAttackRanged setRateFar(int rate) {
        this.attackTimeFar = rate;
        return this;
    }

    public EntityAIAttackRanged setRate(int rate) {
        return this.setRateClose(rate).setRateFar(rate);
    }

    public EntityAIAttackRanged setStaminaTime(int setInt) {
        this.attackStamina = this.attackStaminaMax = setInt;
        return this;
    }

    public EntityAIAttackRanged setStaminaRecoverRate(int rate) {
        this.staminaRecoverRate = rate;
        return this;
    }

    public EntityAIAttackRanged setStaminaDrainRate(int rate) {
        this.staminaDrainRate = rate;
        return this;
    }

    public EntityAIAttackRanged setRange(float setRange) {
        this.range = setRange;
        this.attackDistance = setRange;
        return this;
    }

    public EntityAIAttackRanged setMinChaseDistance(float setMinDist) {
        this.minChaseDistance = setMinDist;
        return this;
    }

    public EntityAIAttackRanged setChaseTime(int setChaseTime) {
        this.chaseTimeMax = setChaseTime;
        return this;
    }

    public EntityAIAttackRanged setFlyingHeight(float setFlyingHeight) {
        this.flyingHeight = setFlyingHeight;
        return this;
    }

    public EntityAIAttackRanged setMountedAttacking(boolean bool) {
        this.mountedAttacking = bool;
        return this;
    }

    public EntityAIAttackRanged setEnabled(boolean setEnabled) {
        this.enabled = setEnabled;
        return this;
    }

    public boolean func_75250_a() {
        EntityCreatureRideable rideableHost;
        if (this.attackStaminaMax > 0 && this.attackOnCooldown) {
            this.attackStamina += this.staminaRecoverRate;
            if (this.attackStamina >= this.attackStaminaMax) {
                this.attackOnCooldown = false;
            }
        }
        if (!this.enabled) {
            return false;
        }
        if (!this.mountedAttacking && this.host instanceof EntityCreatureRideable && (rideableHost = (EntityCreatureRideable)this.host).func_184179_bs() instanceof EntityPlayer) {
            return false;
        }
        EntityLivingBase possibleAttackTarget = this.host.func_70638_az();
        if (possibleAttackTarget == null) {
            return false;
        }
        if (!possibleAttackTarget.func_70089_S()) {
            return false;
        }
        this.attackTarget = possibleAttackTarget;
        return true;
    }

    public boolean func_75253_b() {
        if (!this.longMemory) {
            if (!this.host.useDirectNavigator() && !this.host.func_70661_as().func_75500_f()) {
                return this.func_75250_a();
            }
            if (this.host.useDirectNavigator() && this.host.flightNavigator.targetPosition == null) {
                return this.func_75250_a();
            }
        }
        if (!this.enabled) {
            return false;
        }
        EntityLivingBase possibleAttackTarget = this.host.func_70638_az();
        if (possibleAttackTarget == null) {
            return false;
        }
        if (!possibleAttackTarget.func_70089_S()) {
            return false;
        }
        this.attackTarget = possibleAttackTarget;
        return true;
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.chaseTime = 0;
        this.attackTime = -1;
    }

    public void func_75246_d() {
        double distance = this.host.func_70032_d((Entity)this.attackTarget);
        boolean hasSight = this.host.func_70635_at().func_75522_a((Entity)this.attackTarget);
        float flyingHeightOffset = this.flyingHeight;
        this.chaseTime = hasSight && this.chaseTimeMax >= 0 ? ++this.chaseTime : 0;
        if (!hasSight) {
            flyingHeightOffset = 0.0f;
        }
        if (distance <= (double)this.minChaseDistance || this.chaseTimeMax >= 0 && distance <= (double)this.attackDistance && this.chaseTime >= this.chaseTimeMax) {
            if (!this.host.useDirectNavigator()) {
                this.host.func_70661_as().func_75499_g();
            } else {
                this.host.flightNavigator.clearTargetPosition(1.0);
            }
        } else {
            BlockPos targetPosition = this.attackTarget.func_180425_c();
            if (this.host.canFly()) {
                targetPosition = targetPosition.func_177963_a(0.0, (double)flyingHeightOffset, 0.0);
            }
            if (!this.host.useDirectNavigator()) {
                this.host.func_70661_as().func_75492_a((double)targetPosition.func_177958_n(), (double)targetPosition.func_177956_o(), (double)targetPosition.func_177952_p(), this.speed);
            } else {
                this.host.flightNavigator.setTargetPosition(targetPosition, this.speed);
            }
        }
        this.host.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (this.attackStaminaMax > 0) {
            if (!this.attackOnCooldown) {
                this.attackStamina -= this.staminaDrainRate;
                if (this.attackStamina <= 0) {
                    this.attackOnCooldown = true;
                }
            } else {
                this.attackStamina += this.staminaRecoverRate;
                if (this.attackStamina >= this.attackStaminaMax) {
                    this.attackOnCooldown = false;
                }
            }
        } else if (this.attackOnCooldown) {
            this.attackOnCooldown = false;
        }
        if (!this.attackOnCooldown) {
            if (--this.attackTime == 0) {
                float rangeFactor;
                if (distance > (double)this.attackDistance || this.checkSight && !hasSight) {
                    return;
                }
                float outerRangeFactor = rangeFactor = (float)distance / this.range;
                if (rangeFactor < 0.1f) {
                    outerRangeFactor = 0.1f;
                }
                if (outerRangeFactor > 1.0f) {
                    outerRangeFactor = 1.0f;
                }
                this.host.rangedAttack((Entity)this.attackTarget, outerRangeFactor);
                this.attackTime = rangeFactor > 0.5f ? this.host.getHaste(this.attackTimeFar) : this.host.getHaste(this.attackTimeClose);
            } else if (this.attackTime < 0) {
                float rangeFactor = MathHelper.func_76133_a((double)distance) / this.range;
                this.attackTime = rangeFactor > 0.5f ? this.host.getHaste(this.attackTimeFar) : this.host.getHaste(this.attackTimeClose);
            }
        }
    }
}

