/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.config;

import java.util.ArrayList;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigSpawning
extends ConfigBase {
    public static ConfigSpawning getConfig(GroupInfo group, String configName) {
        ConfigBase config;
        String configFileName = group.filename + "-" + configName.toLowerCase();
        if (!configs.containsKey(configFileName)) {
            ConfigSpawning.registerConfig(new ConfigSpawning(group, configName));
        }
        if ((config = ConfigBase.configs.get(configFileName)) instanceof ConfigSpawning) {
            return (ConfigSpawning)config;
        }
        LycanitesMobs.printWarning("", "[Config] Tried to access the Base Config: " + configName + " as a Spawning Config from group: " + group.name + "!");
        return null;
    }

    public ConfigSpawning(GroupInfo group, String name) {
        super(group, name);
    }

    public SpawnTypeSet getTypes(String category, String key) {
        return this.getTypes(category, key, "");
    }

    public SpawnTypeSet getTypes(String category, String key, String defaultValue) {
        return this.getTypes(category, key, defaultValue, null);
    }

    public SpawnTypeSet getTypes(String category, String key, String defaultValue, String comment) {
        String spawnTypeEntries = this.getString(category, key, defaultValue);
        spawnTypeEntries = spawnTypeEntries.replace(" ", "");
        SpawnTypeBase[] spawnTypes = SpawnTypeBase.getSpawnTypes(spawnTypeEntries);
        ArrayList<EnumCreatureType> creatureTypeList = new ArrayList<EnumCreatureType>();
        for (String spawnTypeEntry : spawnTypeEntries.split(",")) {
            if ("MONSTER".equalsIgnoreCase(spawnTypeEntry)) {
                creatureTypeList.add(EnumCreatureType.MONSTER);
                continue;
            }
            if ("CREATURE".equalsIgnoreCase(spawnTypeEntry) || "ANIMAL".equalsIgnoreCase(spawnTypeEntry)) {
                creatureTypeList.add(EnumCreatureType.CREATURE);
                continue;
            }
            if ("WATERCREATURE".equalsIgnoreCase(spawnTypeEntry)) {
                creatureTypeList.add(EnumCreatureType.WATER_CREATURE);
                continue;
            }
            if (!"AMBIENT".equalsIgnoreCase(spawnTypeEntry)) continue;
            creatureTypeList.add(EnumCreatureType.AMBIENT);
        }
        EnumCreatureType[] creatureTypes = creatureTypeList.toArray(new EnumCreatureType[creatureTypeList.size()]);
        return new SpawnTypeSet(spawnTypes, creatureTypes);
    }

    public SpawnDimensionSet getDimensions(String category, String key) {
        return this.getDimensions(category, key, "");
    }

    public SpawnDimensionSet getDimensions(String category, String key, String defaultValue) {
        return this.getDimensions(category, key, defaultValue, null);
    }

    public SpawnDimensionSet getDimensions(String category, String key, String defaultValue, String comment) {
        String dimensionEntries = this.getString(category, key, defaultValue);
        dimensionEntries = dimensionEntries.replace(" ", "");
        ArrayList<Integer> dimensionIDList = new ArrayList<Integer>();
        ArrayList<String> dimensionTypeList = new ArrayList<String>();
        for (String dimensionEntry : dimensionEntries.split(",")) {
            if (NumberUtils.isNumber((String)dimensionEntry)) {
                dimensionIDList.add(Integer.parseInt(dimensionEntry.replace("+", "")));
                continue;
            }
            dimensionTypeList.add(dimensionEntry.replace("+", ""));
        }
        int[] dimensionIDs = ArrayUtils.toPrimitive((Integer[])dimensionIDList.toArray(new Integer[dimensionIDList.size()]));
        String[] dimensionTypes = dimensionTypeList.toArray(new String[dimensionTypeList.size()]);
        return new SpawnDimensionSet(dimensionIDs, dimensionTypes);
    }

    public BiomeGenBase[] getBiomes(String category, String key) {
        return this.getBiomes(category, key, "");
    }

    public BiomeGenBase[] getBiomes(String category, String key, String defaultValue) {
        return this.getBiomes(category, key, defaultValue, null);
    }

    public BiomeGenBase[] getBiomes(String category, String key, String defaultValue, String comment) {
        String biomeEntries = this.getString(category, key, defaultValue);
        biomeEntries = biomeEntries.replace(" ", "");
        ArrayList<BiomeDictionary.Type> biomeList = new ArrayList<BiomeDictionary.Type>();
        for (String biomeEntry : biomeEntries.split(",")) {
            if ("".equals(biomeEntry)) break;
            boolean additive = true;
            if (biomeEntry.charAt(0) == '-' || biomeEntry.charAt(0) == '+') {
                if (biomeEntry.charAt(0) == '-') {
                    additive = false;
                }
                biomeEntry = biomeEntry.substring(1);
            }
            Object[] selectedBiomes = null;
            if ("ALL".equals(biomeEntry)) {
                for (BiomeDictionary.Type type : BiomeDictionary.Type.values()) {
                    if (selectedBiomes == null) {
                        selectedBiomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
                        continue;
                    }
                    Object[] typeBiomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
                    if (typeBiomes == null) continue;
                    selectedBiomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])selectedBiomes, (Object[])typeBiomes);
                }
            } else if ("GROUP".equals(biomeEntry)) {
                selectedBiomes = this.group.biomes;
            } else if (!"NONE".equals(biomeEntry)) {
                BiomeDictionary.Type biomeType;
                try {
                    biomeType = BiomeDictionary.Type.valueOf((String)biomeEntry);
                }
                catch (Exception e) {
                    biomeType = null;
                    LycanitesMobs.printWarning("", "[Config] Unknown biome type " + biomeEntry + " specified for " + defaultValue + "this will be ignored and treated as NONE.");
                }
                if (biomeType != null) {
                    selectedBiomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType);
                }
            }
            if (selectedBiomes == null) continue;
            for (BiomeDictionary.Type type : selectedBiomes) {
                if (additive && !biomeList.contains(type)) {
                    biomeList.add(type);
                    continue;
                }
                if (additive || !biomeList.contains(type)) continue;
                biomeList.remove(type);
            }
        }
        return biomeList.toArray(new BiomeGenBase[biomeList.size()]);
    }

    public class SpawnDimensionSet {
        public int[] dimensionIDs;
        public String[] dimensionTypes;

        public SpawnDimensionSet(int[] dimensionIDs, String[] dimensionTypes) {
            this.dimensionIDs = dimensionIDs;
            this.dimensionTypes = dimensionTypes;
        }
    }

    public class SpawnTypeSet {
        public SpawnTypeBase[] spawnTypes;
        public EnumCreatureType[] creatureTypes;

        public SpawnTypeSet(SpawnTypeBase[] spawnTypes, EnumCreatureType[] creatureTypes) {
            this.spawnTypes = spawnTypes;
            this.creatureTypes = creatureTypes;
        }
    }
}

