/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.teleporter;

import erebus.ModAchievements;
import erebus.ModBlocks;
import erebus.block.GaeanKeystone;
import erebus.core.handler.configs.ConfigHandler;
import erebus.tileentity.TileEntityGaeanKeystone;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

final class TeleporterErebus
extends Teleporter {
    private final WorldServer worldServerInstance;
    private final LongHashMap destinationCoordinateCache = new LongHashMap();
    private final List<Long> destinationCoordinateKeys = new ArrayList<Long>();

    TeleporterErebus(WorldServer worldServer) {
        super(worldServer);
        this.worldServerInstance = worldServer;
    }

    public void func_77185_a(Entity entity, double x, double y, double z, float rotationYaw) {
        if (!this.func_77184_b(entity, x, y, z, rotationYaw) && this.worldServerInstance.field_73011_w.field_76574_g == ConfigHandler.INSTANCE.erebusDimensionID) {
            this.func_85188_a(entity);
            this.func_77184_b(entity, x, y, z, rotationYaw);
        }
        this.moveToEmptyArea(entity);
    }

    private void moveToEmptyArea(Entity entity) {
        while (!this.isClear(entity)) {
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
    }

    private boolean isClear(Entity ent) {
        AxisAlignedBB box = ent.field_70121_D;
        int minX = MathHelper.func_76128_c((double)box.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0));
        int minY = MathHelper.func_76128_c((double)box.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)(box.field_72337_e + 1.0));
        int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0));
        if ((double)minX < 0.0) {
            --minX;
        }
        if ((double)minY < 0.0) {
            --minY;
        }
        if ((double)minZ < 0.0) {
            --minZ;
        }
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    Block block = this.worldServerInstance.func_147439_a(x, y, z);
                    Material mat = block.func_149688_o();
                    if (!mat.func_76224_d() && !mat.func_76220_a() && mat.func_76227_m() != 2) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean func_77184_b(Entity entity, double x, double y, double z, float rotationYaw) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71029_a((StatBase)ModAchievements.welcome);
        }
        int checkRadius = 32;
        double distToPortal = Double.POSITIVE_INFINITY;
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        int roundX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int roundZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        long coordPair = ChunkCoordIntPair.func_77272_a((int)roundX, (int)roundZ);
        boolean portalNotSaved = true;
        if (this.destinationCoordinateCache.func_76161_b(coordPair)) {
            Teleporter.PortalPosition pos = (Teleporter.PortalPosition)this.destinationCoordinateCache.func_76164_a(coordPair);
            distToPortal = 0.0;
            posX = pos.field_71574_a;
            posY = pos.field_71572_b;
            posZ = pos.field_71573_c;
            pos.field_85087_d = this.worldServerInstance.func_82737_E();
            portalNotSaved = false;
        } else {
            for (int chunkX = roundX - checkRadius; chunkX <= roundX + checkRadius; chunkX += 16) {
                for (int chunkZ = roundZ - checkRadius; chunkZ <= roundZ + checkRadius; chunkZ += 16) {
                    Chunk chunk = this.worldServerInstance.func_72938_d(chunkX, chunkZ);
                    for (TileEntity te : chunk.field_150816_i.values()) {
                        double dz;
                        double dy;
                        double dx;
                        double dSq;
                        if (!(te instanceof TileEntityGaeanKeystone) || (dSq = (dx = entity.field_70165_t - (double)te.field_145851_c) * dx + (dy = 0.0) * dy + (dz = entity.field_70161_v - (double)te.field_145849_e) * dz) > distToPortal) continue;
                        distToPortal = dSq;
                        posX = te.field_145851_c;
                        posY = te.field_145848_d;
                        posZ = te.field_145849_e;
                    }
                }
            }
            distToPortal = Math.sqrt(distToPortal);
        }
        if (distToPortal < (double)checkRadius) {
            if (portalNotSaved) {
                this.destinationCoordinateCache.func_76163_a(coordPair, (Object)new Teleporter.PortalPosition((Teleporter)this, posX, posY, posZ, this.worldServerInstance.func_82737_E()));
                this.destinationCoordinateKeys.add(coordPair);
            }
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            int entityFacing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            float entityRotation = 0.0f;
            switch (entityFacing) {
                case 0: {
                    entityRotation = 180.0f;
                    break;
                }
                case 1: {
                    entityRotation = 270.0f;
                    break;
                }
                case 2: {
                    entityRotation = 0.0f;
                    break;
                }
                case 3: {
                    entityRotation = 90.0f;
                }
            }
            double ex = (double)posX + 0.5;
            double ey = (double)posY + 0.125;
            double ez = (double)posZ + 0.5;
            entity.func_70012_b(ex, ey, ez, entityRotation, entity.field_70125_A);
            if (entity instanceof EntityPlayer && ConfigHandler.INSTANCE.allowRespawning) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71093_bK == ConfigHandler.INSTANCE.erebusDimensionID) {
                    if (!player.getEntityData().func_74764_b("armchairSpawn")) {
                        player.getEntityData().func_74757_a("armchairSpawn", false);
                    }
                    player.getEntityData().func_74768_a("erebusPortalX", posX);
                    player.getEntityData().func_74768_a("erebusPortalY", posY);
                    player.getEntityData().func_74768_a("erebusPortalZ", posZ);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71029_a((StatBase)ModAchievements.welcome);
        }
        double safeHeight = Math.min(Math.max(entity.field_70163_u * 0.5, 12.0), 116.0);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)safeHeight) - 2;
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        ((GaeanKeystone)ModBlocks.gaeanKeystone).buildDestinationPortal((World)this.worldServerInstance, x, y, z);
        return true;
    }

    public void func_85189_a(long timer) {
        if (timer % 100L == 0L) {
            Iterator<Long> iterator = this.destinationCoordinateKeys.iterator();
            while (iterator.hasNext()) {
                Long hashedPortalPos = iterator.next();
                Teleporter.PortalPosition position = (Teleporter.PortalPosition)this.destinationCoordinateCache.func_76164_a(hashedPortalPos.longValue());
                if (position != null && position.field_85087_d >= timer - 600L) continue;
                iterator.remove();
                this.destinationCoordinateCache.func_76159_d(hashedPortalPos.longValue());
            }
        }
    }
}

