/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.util;

import net.minecraft.block.Block;
import net.minecraft.world.World;

public class BasicShapeGen {
    public final void createSphere(World world, Block block, int metaData, boolean isHollow, int x, int y, int z, int radius) {
        for (int x1 = x - radius; x1 <= x + radius; ++x1) {
            for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                for (int y1 = y - radius; y1 < y + radius; ++y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) >= (long)radius) continue;
                    if (dSq >= Math.pow(radius - 2, 2.0)) {
                        world.func_147465_d(x1, y1, z1, block, metaData, 3);
                        continue;
                    }
                    if (!isHollow) continue;
                    world.func_147468_f(x1, y1, z1);
                }
            }
        }
    }

    public final void createSemiSphereBottom(World world, Block block, int metaData, boolean isHollow, int x, int y, int z, int radius) {
        for (int x1 = x - radius; x1 <= x + radius; ++x1) {
            for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                for (int y1 = y; y1 > y - radius; --y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) >= (long)radius) continue;
                    if (dSq >= Math.pow(radius - 2, 2.0) || y1 == y) {
                        world.func_147465_d(x1, y1, z1, block, metaData, 3);
                        continue;
                    }
                    if (!isHollow) continue;
                    world.func_147468_f(x1, y1, z1);
                }
            }
        }
    }

    public final void createSemiSphereTop(World world, Block block, int metaData, boolean isHollow, int x, int y, int z, int radius) {
        for (int x1 = x - radius; x1 <= x + radius; ++x1) {
            for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                for (int y1 = y; y1 < y + radius; ++y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) >= (long)radius) continue;
                    if (dSq >= Math.pow(radius - 2, 2.0) || y1 == y) {
                        world.func_147465_d(x1, y1, z1, block, metaData, 3);
                        continue;
                    }
                    if (!isHollow) continue;
                    world.func_147468_f(x1, y1, z1);
                }
            }
        }
    }

    public final void createPyramid(World world, Block block, int metaData, boolean isHollow, int x, int z, int baseLengthX, int baseLengthZ, int yStart) {
        int yStop = Math.min((baseLengthZ - 1) / 2, (baseLengthX - 1) / 2) + yStart;
        int i = 0;
        while (i + yStart <= yStop) {
            int y = yStart + i;
            int maxX = x + baseLengthX - 1;
            int maxZ = z + baseLengthZ - 1;
            int ix = 0;
            while (x + ix + i <= maxX) {
                int iz = 0;
                while (z + iz + i <= maxZ) {
                    if (ix == 0 || ix + i + 1 == baseLengthX || iz == 0 || iz + i + 1 == baseLengthZ) {
                        world.func_147465_d(ix + x + i, y, iz + z + i, block, metaData, 3);
                    } else if (isHollow) {
                        world.func_147468_f(ix + x + i, y, iz + z + i);
                    }
                    ++iz;
                }
                ++ix;
            }
            --baseLengthX;
            --baseLengthZ;
            ++i;
        }
    }
}

