/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.lib.EnumWood;
import erebus.world.feature.tree.WorldGenTreeBase;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenMossbarkTree
extends WorldGenTreeBase {
    private static final int[] offsetX = new int[]{-1, 1, 0, 0};
    private static final int[] offsetZ = new int[]{0, 0, -1, 1};

    public WorldGenMossbarkTree() {
        super(EnumWood.Mossbark);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int a;
        int testY;
        int[] middleBranchHeights = new int[4];
        int[] outsideBranchHeights = new int[4];
        int stumpHeight = 4 + rand.nextInt(3);
        int maxBranchHeight = 0;
        for (int a2 = 0; a2 < 4; ++a2) {
            middleBranchHeights[a2] = 1 + rand.nextInt(2);
            outsideBranchHeights[a2] = middleBranchHeights[a2] + rand.nextInt(4);
            if (middleBranchHeights[a2] + outsideBranchHeights[a2] <= maxBranchHeight) continue;
            maxBranchHeight = middleBranchHeights[a2] + outsideBranchHeights[a2];
        }
        int maxHeight = stumpHeight + maxBranchHeight + 2;
        if (y <= 0 || y + maxHeight > 255) {
            return false;
        }
        for (testY = y + 1; testY < y + 3; ++testY) {
            if (world.func_147437_c(x, testY, z)) continue;
            return false;
        }
        for (testY = y + 3; testY <= y + 1 + maxHeight; ++testY) {
            int testZ;
            int testX;
            for (testX = x - 4; testX <= x + 4; ++testX) {
                for (testZ = z - 1; testZ <= z + 1; ++testZ) {
                    if (world.func_147437_c(testX, testY, testZ)) continue;
                    return false;
                }
            }
            for (testX = x - 1; testX <= x + 1; ++testX) {
                for (testZ = z - 4; testZ <= z + 4; ++testZ) {
                    if (world.func_147437_c(testX, testY, testZ)) continue;
                    return false;
                }
            }
        }
        if (world.func_147439_a(x, y - 1, z) != Blocks.field_150346_d && world.func_147439_a(x, y - 1, z) != Blocks.field_150349_c) {
            return false;
        }
        this.generateStump(world, rand, x, y, z, stumpHeight);
        y += stumpHeight;
        for (a = 0; a < 4; ++a) {
            this.generateMiddleBranch(world, rand, x + offsetX[a] * 2, y, z + offsetZ[a] * 2, middleBranchHeights[a]);
        }
        for (a = 0; a < 4; ++a) {
            this.generateOutsideBranch(world, rand, x + offsetX[a] * 3, y + middleBranchHeights[a], z + offsetZ[a] * 3, outsideBranchHeights[a]);
        }
        return true;
    }

    public void generateStump(World world, Random random, int x, int y, int z, int height) {
        for (int yy = 0; yy < height; ++yy) {
            world.func_147465_d(x, y + yy, z, this.log, 0, 3);
            if (yy != height - 1) continue;
            world.func_147465_d(x, y + yy, z + 1, this.log, 8, 3);
            world.func_147465_d(x, y + yy, z - 1, this.log, 8, 3);
            world.func_147465_d(x + 1, y + yy, z, this.log, 4, 3);
            world.func_147465_d(x - 1, y + yy, z, this.log, 4, 3);
            break;
        }
    }

    public void generateMiddleBranch(World world, Random rand, int x, int y, int z, int height) {
        int yy;
        for (yy = 0; yy < 2; ++yy) {
            world.func_147465_d(x, y - 1 - yy, z, this.leaves, 0, 3);
        }
        for (yy = 0; yy < height; ++yy) {
            world.func_147465_d(x, y + yy, z, this.log, 0, 3);
        }
    }

    public void generateOutsideBranch(World world, Random rand, int x, int y, int z, int height) {
        int yy;
        for (yy = 0; yy < 2; ++yy) {
            world.func_147465_d(x, y - 1 - yy, z, this.leaves, 0, 3);
            world.func_147465_d(x, y + height + yy, z, this.leaves, 0, 3);
        }
        for (yy = 0; yy < height; ++yy) {
            if (yy < height - 1) {
                world.func_147465_d(x, y + yy, z, this.log, 0, 3);
            }
            for (int a = 0; a < 4; ++a) {
                world.func_147465_d(x + offsetX[a], y + yy, z + offsetZ[a], this.leaves, 0, 3);
            }
        }
    }
}

