/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.lib.EnumWood;
import erebus.world.feature.tree.WorldGenTreeBase;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.world.World;

public class WorldGenCypressTree
extends WorldGenTreeBase {
    public WorldGenCypressTree() {
        super(EnumWood.Cypress);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        float treeRand = rand.nextFloat();
        if (treeRand >= 0.5f) {
            return this.generateMediumTree(world, rand, x, y, z);
        }
        if (treeRand >= 0.3f) {
            return this.generateLargeTree(world, rand, x, y, z);
        }
        return this.generateSmallTree(world, rand, x, y, z);
    }

    private boolean checkEmptyArea(World world, int x, int y, int z, int totalHeight, int rad) {
        if (world.func_147439_a(x, y, z).func_149688_o() != Material.field_151579_a) {
            return false;
        }
        for (int xx = x - rad; xx <= x + rad; ++xx) {
            for (int zz = z - rad; zz <= z + rad; ++zz) {
                for (int yy = y + 1; yy <= y + totalHeight; ++yy) {
                    if (world.func_147439_a(xx, yy, zz).func_149688_o() == Material.field_151579_a) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean generateSmallTree(World world, Random rand, int x, int y, int z) {
        int a;
        int yy;
        int trunkH = rand.nextInt(4) + 5;
        int nakedTrunkH = rand.nextInt(2) + 1;
        int leafH = trunkH - nakedTrunkH;
        if (!this.checkEmptyArea(world, x, y, z, trunkH + 2, 2)) {
            return false;
        }
        for (yy = y; yy <= y + trunkH; ++yy) {
            world.func_147465_d(x, yy, z, this.log, 0, 2);
        }
        for (yy = y + trunkH + 1; yy <= y + trunkH + 2; ++yy) {
            world.func_147465_d(x, yy, z, this.leaves, 0, 2);
        }
        for (a = 0; a < 4; ++a) {
            int yy2;
            for (yy2 = y + nakedTrunkH; yy2 <= y + trunkH; ++yy2) {
                world.func_147465_d(x + Direction.field_71583_a[a], yy2, z + Direction.field_71581_b[a], this.leaves, 0, 2);
            }
            if (leafH - 4 <= 1) continue;
            for (yy2 = y + nakedTrunkH + 2; yy2 <= y + trunkH - 2; ++yy2) {
                if ((yy2 == y + nakedTrunkH + 2 || yy2 == y + trunkH - 2) && leafH - 4 > 3 && rand.nextInt(11) == 0) continue;
                world.func_147465_d(x + Direction.field_71583_a[a] * 2, yy2, z + Direction.field_71581_b[a] * 2, this.leaves, 0, 2);
            }
        }
        for (a = 0; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                for (int yy3 = y + nakedTrunkH + 1; yy3 <= y + trunkH - 1; ++yy3) {
                    if ((yy3 == y + nakedTrunkH + 1 || yy3 == y + trunkH - 1) && leafH - 2 > 3 && rand.nextInt(8) == 0) continue;
                    world.func_147465_d(x - 1 + 2 * a, yy3, z - 1 + 2 * b, this.leaves, 0, 2);
                }
            }
        }
        return true;
    }

    private boolean generateMediumTree(World world, Random rand, int x, int y, int z) {
        int a;
        int yy;
        int trunkH = rand.nextInt(5) + 8;
        int nakedTrunkH = rand.nextInt(3) + 1;
        int leafH = trunkH - nakedTrunkH;
        if (!this.checkEmptyArea(world, x, y, z, trunkH + 3, 3)) {
            return false;
        }
        for (yy = y; yy <= y + trunkH; ++yy) {
            world.func_147465_d(x, yy, z, this.log, 0, 2);
        }
        for (yy = y + trunkH + 1; yy <= y + trunkH + 3; ++yy) {
            world.func_147465_d(x, yy, z, this.leaves, 0, 2);
        }
        for (a = 0; a < 4; ++a) {
            int yy2;
            for (yy2 = y + nakedTrunkH; yy2 <= y + trunkH + 1; ++yy2) {
                world.func_147465_d(x + Direction.field_71583_a[a], yy2, z + Direction.field_71581_b[a], this.leaves, 0, 2);
            }
            for (yy2 = y + nakedTrunkH + 1; yy2 <= y + trunkH - 2; ++yy2) {
                world.func_147465_d(x + Direction.field_71583_a[a] * 2, yy2, z + Direction.field_71581_b[a] * 2, this.leaves, 0, 2);
            }
            if (leafH - 7 <= 1) continue;
            for (yy2 = y + nakedTrunkH + 3; yy2 <= y + trunkH - 4; ++yy2) {
                if ((yy2 == y + nakedTrunkH + 3 || yy2 == y + trunkH - 4) && leafH - 7 > 3 && rand.nextInt(10) == 0) continue;
                world.func_147465_d(x + Direction.field_71583_a[a] * 3, yy2, z + Direction.field_71581_b[a] * 3, this.leaves, 0, 2);
            }
        }
        for (a = 0; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                int yy3;
                for (yy3 = y + nakedTrunkH + 1; yy3 <= y + trunkH - 1; ++yy3) {
                    if ((yy3 == y + nakedTrunkH + 1 || yy3 == y + trunkH - 1) && rand.nextInt(14) == 0) continue;
                    world.func_147465_d(x - 1 + 2 * a, yy3, z + -1 + 2 * b, this.leaves, 0, 2);
                }
                for (yy3 = y + nakedTrunkH + 2; yy3 <= y + trunkH - 3; ++yy3) {
                    boolean canSkip;
                    boolean bl = canSkip = yy3 == y + nakedTrunkH + 2 || yy3 == y + trunkH - 3;
                    if (!canSkip || rand.nextInt(10) != 0) {
                        world.func_147465_d(x - 2 + 4 * a, yy3, z + -1 + 2 * b, this.leaves, 0, 2);
                    }
                    if (canSkip && rand.nextInt(10) == 0) continue;
                    world.func_147465_d(x - 1 + 2 * a, yy3, z + -2 + 4 * b, this.leaves, 0, 2);
                }
            }
        }
        return true;
    }

    private boolean generateLargeTree(World world, Random rand, int x, int y, int z) {
        int a;
        int yy;
        int trunkH = rand.nextInt(6) + 12;
        int nakedTrunkH = rand.nextInt(3) + 2;
        int leafH = trunkH - nakedTrunkH;
        if (!this.checkEmptyArea(world, x, y, z, trunkH + 4, 3)) {
            return false;
        }
        for (yy = y; yy <= y + trunkH; ++yy) {
            world.func_147465_d(x, yy, z, this.log, 0, 2);
            if (yy > y + trunkH - 2) continue;
            for (int a2 = 0; a2 < 4; ++a2) {
                boolean genLog = yy >= y + trunkH - 3 && rand.nextBoolean() || yy < y + trunkH - 3;
                world.func_147465_d(x + Direction.field_71583_a[a2], yy, z + Direction.field_71581_b[a2], genLog ? this.log : this.leaves, genLog ? 0 : 0, 2);
            }
        }
        for (yy = y + trunkH + 1; yy <= y + trunkH + 4; ++yy) {
            world.func_147465_d(x, yy, z, this.leaves, 0, 2);
        }
        for (a = 0; a < 4; ++a) {
            int yy2;
            for (yy2 = y + trunkH - 1; yy2 <= y + trunkH + 2; ++yy2) {
                if (yy2 == y + trunkH + 2 && rand.nextInt(5) == 0) continue;
                world.func_147465_d(x + Direction.field_71583_a[a], yy2, z + Direction.field_71581_b[a], this.leaves, 0, 2);
            }
            for (yy2 = y + nakedTrunkH; yy2 <= y + trunkH; ++yy2) {
                if (yy2 == y + trunkH && rand.nextInt(6) == 0) continue;
                world.func_147465_d(x + Direction.field_71583_a[a] * 2, yy2, z + Direction.field_71581_b[a] * 2, this.leaves, 0, 2);
            }
            for (yy2 = y + nakedTrunkH + 2; yy2 <= y + trunkH - 3; ++yy2) {
                world.func_147465_d(x + Direction.field_71583_a[a] * 3, yy2, z + Direction.field_71581_b[a] * 3, this.leaves, 0, 2);
            }
        }
        for (a = 0; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                boolean canSkip;
                int yy3;
                for (yy3 = y + nakedTrunkH; yy3 <= y + trunkH + 1; ++yy3) {
                    world.func_147465_d(x - 1 + 2 * a, yy3, z - 1 + 2 * b, this.leaves, 0, 2);
                }
                for (yy3 = y + nakedTrunkH + 1; yy3 <= y + trunkH - 2; ++yy3) {
                    boolean bl = canSkip = yy3 == y + nakedTrunkH + 1 || yy3 == y + trunkH - 2;
                    if (!canSkip || rand.nextInt(10) != 0) {
                        world.func_147465_d(x - 2 + 4 * a, yy3, z - 1 + 2 * b, this.leaves, 0, 2);
                    }
                    if (canSkip && rand.nextInt(10) == 0) continue;
                    world.func_147465_d(x - 1 + 2 * a, yy3, z - 2 + 4 * b, this.leaves, 0, 2);
                }
                for (yy3 = y + nakedTrunkH + 3; yy3 <= y + trunkH - 3; ++yy3) {
                    if (yy3 == y + trunkH - 3 && rand.nextInt(7) == 0) continue;
                    world.func_147465_d(x - 2 + 4 * a, yy3, z - 2 + 4 * b, this.leaves, 0, 2);
                }
                if (leafH - 9 <= 1) continue;
                for (yy3 = y + nakedTrunkH + 4; yy3 <= y + trunkH - 5; ++yy3) {
                    boolean bl = canSkip = (yy3 == y + nakedTrunkH + 4 || yy3 == y + trunkH - 5) && leafH - 9 > 2;
                    if (!canSkip || rand.nextInt(12) != 0) {
                        world.func_147465_d(x - 3 + 6 * a, yy3, z - 1 + 2 * b, this.leaves, 0, 2);
                    }
                    if (canSkip && rand.nextInt(12) == 0) continue;
                    world.func_147465_d(x - 1 + 2 * a, yy3, z - 3 + 6 * b, this.leaves, 0, 2);
                }
            }
        }
        return true;
    }
}

