/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.structure;

import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.entity.EntityAntlionBoss;
import erebus.entity.EntityUmberGolemDungeonTypes;
import erebus.item.ItemErebusFood;
import erebus.item.ItemMaterials;
import erebus.item.ItemSmoothie;
import erebus.tileentity.TileEntityBones;
import erebus.tileentity.TileEntityTempleTeleporter;
import erebus.world.feature.util.PerfectMazeGenerator;
import erebus.world.loot.IPostProcess;
import erebus.world.loot.LootItemStack;
import erebus.world.loot.LootUtil;
import erebus.world.loot.WeightedLootList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AntlionMazeDungeon {
    private Block solid = ModBlocks.gneiss;
    public static final WeightedLootList chestLoot = new WeightedLootList(new LootItemStack[]{new LootItemStack(Items.field_151122_aG).setAmount(1, 4).setWeight(18), new LootItemStack(Items.field_151121_aF).setAmount(2, 6).setWeight(16), new LootItemStack(Blocks.field_150321_G).setAmount(2, 7).setWeight(13), new LootItemStack(ModItems.materials).setAmount(1, 3).setDamage(ItemMaterials.DATA.JADE.ordinal()).setWeight(10), new LootItemStack(ModItems.materials).setAmount(4, 8).setDamage(ItemMaterials.DATA.PLATE_EXO.ordinal()).setWeight(9), new LootItemStack((Item)Items.field_151134_bR).setWeight(8), new LootItemStack(ModBlocks.umberGolemStatue).setAmount(1).setWeight(1), new LootItemStack(ModItems.webSlinger).setAmount(1).setWeight(1), new LootItemStack(Items.field_151005_D).setWeight(3), new LootItemStack(Items.field_151035_b).setWeight(2), new LootItemStack(ModItems.jadePickaxe).setWeight(1), new LootItemStack(Items.field_151011_C).setWeight(3), new LootItemStack(Items.field_151037_a).setWeight(2), new LootItemStack(ModItems.jadeShovel).setWeight(1), new LootItemStack(Items.field_151006_E).setWeight(3), new LootItemStack(Items.field_151036_c).setWeight(2), new LootItemStack(ModItems.jadeAxe).setWeight(1), new LootItemStack(Items.field_151010_B).setWeight(3), new LootItemStack(Items.field_151040_l).setWeight(2), new LootItemStack(ModItems.jadeSword).setWeight(1), new LootItemStack((Item)Items.field_151030_Z).setWeight(2), new LootItemStack(ModItems.jadeBody).setWeight(1), new LootItemStack((Item)Items.field_151171_ah).setWeight(1), new LootItemStack((Item)Items.field_151028_Y).setWeight(2), new LootItemStack(ModItems.jadeHelmet).setWeight(1), new LootItemStack((Item)Items.field_151169_ag).setWeight(1), new LootItemStack((Item)Items.field_151165_aa).setWeight(2), new LootItemStack(ModItems.jadeLegs).setWeight(1), new LootItemStack((Item)Items.field_151149_ai).setWeight(1), new LootItemStack((Item)Items.field_151167_ab).setWeight(2), new LootItemStack(ModItems.jadeBoots).setWeight(1), new LootItemStack((Item)Items.field_151151_aj).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.ALTAR_FRAGMENT.ordinal()).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.REINFORCED_PLATE_EXO.ordinal()).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.SCORPION_PINCER.ordinal()).setWeight(1), new LootItemStack(ModItems.materials).setAmount(1, 3).setDamage(ItemMaterials.DATA.WHETSTONE_POWDER.ordinal()).setWeight(3), new LootItemStack(ModItems.materials).setAmount(1).setDamage(ItemMaterials.DATA.PLATE_EXO_RHINO.ordinal()).setWeight(1), new LootItemStack(ModItems.food).setAmount(1, 3).setDamage(ItemErebusFood.FoodType.HONEY_SANDWICH.ordinal()).setWeight(3), new LootItemStack(ModItems.cabbageSeeds).setAmount(1, 3).setWeight(2), new LootItemStack(ModItems.whetstone).setAmount(1).setDamage(0).setWeight(1), new LootItemStack(ModItems.lifeBlood).setAmount(1, 2).setWeight(4), new LootItemStack(ModItems.rolledNewspaper).setAmount(1).setWeight(1), new LootItemStack(ModItems.waspDagger).setAmount(1, 3).setWeight(2), new LootItemStack(ModItems.bucketAntiVenom).setAmount(1).setWeight(1), new LootItemStack(ModItems.bucketBeetleJuice).setAmount(1).setWeight(1), new LootItemStack(ModItems.bucketHoney).setAmount(1).setWeight(1), new LootItemStack(ModBlocks.glowGemBlock).setAmount(1, 3).setWeight(5), new LootItemStack(ModItems.homingBeecon).setAmount(1).setWeight(1), new LootItemStack(ModItems.smoothie).setAmount(1, 3).setDamage(ItemSmoothie.SmoothieType.GIVIN_ME_THE_BLUES.ordinal()).setWeight(3), new LootItemStack(ModItems.smoothie).setAmount(1).setDamage(ItemSmoothie.SmoothieType.BRYUFS_BREW.ordinal()).setWeight(1)}).setPostProcessor(new IPostProcess(){

        @Override
        public ItemStack postProcessItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == Items.field_151134_bR || rand.nextBoolean() && (is.func_77973_b() instanceof ItemTool || is.func_77973_b() instanceof ItemArmor || is.func_77973_b() instanceof ItemSword)) {
                boolean enchBook;
                boolean bl = enchBook = is.func_77973_b() == Items.field_151134_bR;
                if (enchBook) {
                    is.func_150996_a(Items.field_151122_aG);
                }
                List enchList = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)is, (int)(7 + rand.nextInt(10)));
                if (enchBook) {
                    is.func_150996_a((Item)Items.field_151134_bR);
                }
                if (enchList != null && enchList.size() > 0) {
                    for (int a = 0; a < enchList.size(); ++a) {
                        EnchantmentData data = (EnchantmentData)enchList.get(a);
                        if (is.func_77973_b() == Items.field_151134_bR) {
                            Items.field_151134_bR.func_92115_a(is, data);
                            continue;
                        }
                        is.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
            }
            return is;
        }
    });

    public void generateSurface(World world, Random rand, int chunkX, int chunkY, int chunkZ) {
        BiomeGenBase biomeBase = world.func_72807_a(chunkX, chunkZ);
        if (biomeBase == ModBiomes.volcanicDesert && world.func_72899_e(chunkX, chunkY, chunkZ) && world.func_147439_a(chunkX, chunkY, chunkZ) != this.solid) {
            this.generate(world, rand, chunkX, chunkY, chunkZ);
        }
    }

    public void generate(World world, Random rand, int x, int y, int z) {
        int sizeX = 60;
        int sizeY = y + 4;
        int sizeZ = 60;
        int mazeWidth = sizeX / 2;
        int mazeHeight = sizeZ / 2;
        if (mazeWidth < 2 || mazeHeight < 2 || sizeY < 1) {
            return;
        }
        int[][] maze = null;
        PerfectMazeGenerator generator = new PerfectMazeGenerator(mazeWidth, mazeHeight);
        maze = generator.generateMaze();
        block4: for (int yy = y; yy < sizeY; ++yy) {
            switch ((yy - y) % 4) {
                case 0: {
                    this.buildFloor(world, x, yy - 4, z, mazeWidth, mazeHeight, rand);
                    this.buildRoof(world, x, yy, z, mazeWidth, mazeHeight, rand);
                    continue block4;
                }
                case 1: {
                    this.buildLevel(world, x, yy - 4, z, mazeWidth, mazeHeight, maze, this.solid, 2);
                    this.buildLevel(world, x, yy - 3, z, mazeWidth, mazeHeight, maze, this.solid, 1);
                    this.buildLevel(world, x, yy - 2, z, mazeWidth, mazeHeight, maze, this.solid, 2);
                    this.createAir(world, x, yy - 4, z, mazeWidth, mazeHeight, rand);
                    this.addFeature(world, x, yy - 3, z, mazeWidth, mazeHeight, maze, rand);
                }
            }
        }
        this.buildCourtyard(world, ModBlocks.templePillar, 0, x + sizeX, y - 4, z + sizeZ, 52, 4, 52);
        this.createPyramid(world, ModBlocks.templeBrickUnbreaking, 0, true, x + sizeX / 2 + 8, z + sizeZ / 2 + 8, 44, 44, y - 6);
        this.decoratePyramid(world, x + sizeX / 2 + 8, y - 6, z + sizeZ / 2 + 8);
        this.addTeleporters(world, x + sizeX / 2 + 8, y - 6, z + sizeZ / 2 + 8);
        this.addCapstones(world, x + sizeX - 1, y + 15, z + sizeZ - 1, ModBlocks.capstone);
        this.spawnIdolGuardians(world, x, y, z);
    }

    private void createAir(World world, int x, int y, int z, int w, int h, Random rand) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    if (world.func_147439_a(x + j, y + k, z + i) == this.solid) continue;
                    world.func_147468_f(x + j, y + k, z + i);
                }
            }
        }
    }

    private void addTeleporters(World world, int x, int y, int z) {
        world.func_147465_d(x + 13, y + 9, z + 13, ModBlocks.capstone, 0, 2);
        this.setFloorDecoStone(world, x + 14, y + 9, z + 14);
        this.setLockStone(world, x + 15, y + 9, z + 15, 2);
        AntlionMazeDungeon.setTeleporter(world, x + 16, y + 9, z + 16, 0, x + 30, y + 9, z + 13);
        AntlionMazeDungeon.setTeleporter(world, x + 19, y + 9, z + 19, 5, x + 19, y + 14, z + 19);
        world.func_147465_d(x + 30, y + 9, z + 13, ModBlocks.capstone, 0, 2);
        this.setFloorDecoStone(world, x + 25, y + 9, z + 14);
        this.setLockStone(world, x + 26, y + 9, z + 15, 3);
        AntlionMazeDungeon.setTeleporter(world, x + 27, y + 9, z + 16, 0, x + 30, y + 9, z + 30);
        AntlionMazeDungeon.setTeleporter(world, x + 24, y + 9, z + 19, 5, x + 13, y + 9, z + 13);
        world.func_147465_d(x + 30, y + 9, z + 30, ModBlocks.capstone, 0, 2);
        this.setFloorDecoStone(world, x + 25, y + 9, z + 25);
        this.setLockStone(world, x + 26, y + 9, z + 26, 4);
        AntlionMazeDungeon.setTeleporter(world, x + 27, y + 9, z + 27, 0, x + 13, y + 9, z + 30);
        AntlionMazeDungeon.setTeleporter(world, x + 24, y + 9, z + 24, 5, x + 30, y + 9, z + 13);
        world.func_147465_d(x + 13, y + 9, z + 30, ModBlocks.capstone, 0, 2);
        this.setFloorDecoStone(world, x + 14, y + 9, z + 25);
        this.setLockStone(world, x + 15, y + 9, z + 26, 5);
        AntlionMazeDungeon.setTeleporter(world, x + 16, y + 9, z + 27, 0, x + 13, y + 9, z + 13);
        AntlionMazeDungeon.setTeleporter(world, x + 19, y + 9, z + 24, 5, x + 30, y + 9, z + 30);
        AntlionMazeDungeon.setFloorMidDecoStone(world, x + 20, y + 9, z + 20);
        AntlionMazeDungeon.setTeleporter(world, x + 22, y + 9, z + 21, 6, x + 5, y + 1, z + 5);
        AntlionMazeDungeon.setTeleporter(world, x + 21, y + 9, z + 21, 7, x + 38, y + 1, z + 5);
        AntlionMazeDungeon.setTeleporter(world, x + 22, y + 9, z + 22, 8, x + 38, y + 1, z + 38);
        AntlionMazeDungeon.setTeleporter(world, x + 21, y + 9, z + 22, 9, x + 5, y + 1, z + 38);
        world.func_147465_d(x + 19, y + 14, z + 19, ModBlocks.capstone, 0, 2);
        world.func_147465_d(x + 19, y + 15, z + 25, ModBlocks.bambooTorch, 0, 3);
        world.func_147465_d(x + 19, y + 16, z + 25, ModBlocks.bambooTorch, 1, 3);
        world.func_147465_d(x + 25, y + 15, z + 19, ModBlocks.bambooTorch, 0, 3);
        world.func_147465_d(x + 25, y + 16, z + 19, ModBlocks.bambooTorch, 1, 3);
        this.setFloorDecoStone(world, x + 20, y + 14, z + 20);
        this.setLockStone(world, x + 21, y + 14, z + 21, 1);
        AntlionMazeDungeon.setTeleporter(world, x + 22, y + 14, z + 22, 0, x + 13, y + 9, z + 13);
        AntlionMazeDungeon.setTeleporter(world, x + 25, y + 14, z + 25, 5, x + 19, y + 14, z + 19);
    }

    private void setLockStone(World world, int x, int y, int z, int meta) {
        for (int dx = x; dx < x + 3; ++dx) {
            for (int dz = z; dz < z + 3; ++dz) {
                world.func_147465_d(dx, y, dz, ModBlocks.templeBrickUnbreaking, meta, 2);
            }
        }
    }

    private void setFloorDecoStone(World world, int x, int y, int z) {
        for (int dx = x; dx < x + 5; ++dx) {
            for (int dz = z; dz < z + 5; ++dz) {
                world.func_147465_d(dx, y, dz, ModBlocks.capstone, 0, 2);
            }
        }
    }

    private static void setFloorMidDecoStone(World world, int x, int y, int z) {
        for (int dx = x; dx < x + 4; ++dx) {
            for (int dz = z; dz < z + 4; ++dz) {
                world.func_147465_d(dx, y, dz, ModBlocks.capstone, 0, 2);
            }
        }
    }

    private void decoratePyramid(World world, int x, int y, int z) {
        boolean forcefieldSet = false;
        boolean topchestSet = false;
        for (int yy = y; yy < y + 30; ++yy) {
            for (int xx = x; xx < x + 44; ++xx) {
                for (int zz = z; zz < z + 44; ++zz) {
                    if (yy == y) {
                        world.func_147465_d(xx, yy, zz, ModBlocks.templeBrickUnbreaking, 0, 2);
                    }
                    if (yy == y + 1) {
                        if (xx > x + 1 && xx < x + 42 && zz > z + 1 && zz < z + 42) {
                            world.func_147465_d(xx, yy, zz, (Block)Blocks.field_150354_m, 0, 2);
                        }
                        if (xx > x + 4 && xx < x + 39 && zz > z + 4 && zz < z + 39) {
                            if ((xx - x) % 11 == 5 || (zz - z) % 11 == 5) {
                                world.func_147465_d(xx, yy, zz, ModBlocks.gneissVent, 0, 2);
                            } else {
                                world.func_147465_d(xx, yy, zz, (Block)Blocks.field_150354_m, 0, 2);
                            }
                        }
                    }
                    if (yy == y + 9 && xx > x + 9 && xx < x + 34 && zz > z + 9 && zz < z + 34) {
                        world.func_147465_d(xx, yy, zz, ModBlocks.templeBrickUnbreaking, 0, 2);
                    }
                    if (yy == y + 10 && !forcefieldSet) {
                        for (int d = 0; d < 4; ++d) {
                            for (int wx = 0 + d; wx < 9; ++wx) {
                                world.func_147465_d(x + 11 + wx, yy + d, z + 21, ModBlocks.forceField, 0, 2);
                                world.func_147465_d(x + 11 + wx, yy + d, z + 22, ModBlocks.forceField, 0, 2);
                                world.func_147465_d(x + 21, yy + d, z + 11 + wx, ModBlocks.forceField, 0, 2);
                                world.func_147465_d(x + 22, yy + d, z + 11 + wx, ModBlocks.forceField, 0, 2);
                                world.func_147465_d(x + 21, yy + d, z + 32 - wx, ModBlocks.forceField, 0, 2);
                                world.func_147465_d(x + 22, yy + d, z + 32 - wx, ModBlocks.forceField, 0, 2);
                                world.func_147465_d(x + 32 - wx, yy + d, z + 21, ModBlocks.forceField, 0, 2);
                                world.func_147465_d(x + 32 - wx, yy + d, z + 22, ModBlocks.forceField, 0, 2);
                            }
                            for (int dx = x + 20; dx < x + 24; ++dx) {
                                for (int dz = z + 20; dz < z + 24; ++dz) {
                                    world.func_147465_d(dx, yy + d, dz, ModBlocks.forceField, 0, 2);
                                }
                            }
                            for (int dx1 = x + 21; dx1 < x + 23; ++dx1) {
                                for (int dz1 = z + 21; dz1 < z + 23; ++dz1) {
                                    world.func_147468_f(dx1, yy + d, dz1);
                                }
                            }
                        }
                        forcefieldSet = true;
                    }
                    if (yy == y + 14 && xx > x + 14 && xx < x + 29 && zz > z + 14 && zz < z + 29) {
                        world.func_147465_d(xx, yy, zz, ModBlocks.templeBrickUnbreaking, 0, 2);
                    }
                    if (yy == y + 15 && !topchestSet) {
                        world.func_147465_d(x + 19, yy, z + 22, (Block)Blocks.field_150486_ae, 2, 2);
                        TileEntityChest chest = (TileEntityChest)world.func_147438_o(x + 19, yy, z + 22);
                        if (chest != null) {
                            chest.func_70299_a(0, ItemMaterials.DATA.JADE.makeStack(8));
                        }
                        world.func_72921_c(x + 19, yy, z + 22, 2, 3);
                    }
                    if (yy != y + 16) continue;
                }
            }
        }
    }

    public static void setTeleporter(World world, int x, int y, int z, int metaData, int targetX, int targetY, int targetZ) {
        world.func_147465_d(x, y, z, ModBlocks.templeTeleporter, metaData, 2);
        TileEntityTempleTeleporter teleporter = (TileEntityTempleTeleporter)world.func_147438_o(x, y, z);
        if (teleporter != null) {
            teleporter.setTargetDestination(targetX, targetY, targetZ);
        }
    }

    private void addCapstones(World world, int x, int y, int z, Block capstone) {
        world.func_147465_d(x, y, z, capstone, 1, 3);
        world.func_147465_d(x + 1, y, z, capstone, 2, 3);
        world.func_147465_d(x, y, z + 1, capstone, 3, 3);
        world.func_147465_d(x + 1, y, z + 1, capstone, 4, 3);
    }

    private void createPyramid(World world, Block block, int metaData, boolean isHollow, int x, int z, int baseLengthX, int baseLengthZ, int yStart) {
        int yStop = Math.min((baseLengthZ - 1) / 2, (baseLengthX - 1) / 2) + yStart;
        int i = 0;
        while (i + yStart <= yStop - 1) {
            int y = yStart + i;
            int maxX = x + baseLengthX - 1;
            int maxZ = z + baseLengthZ - 1;
            int ix = 0;
            while (x + ix + i <= maxX) {
                int iz = 0;
                while (z + iz + i <= maxZ) {
                    if (ix == 0 || ix + i + 1 == baseLengthX || iz == 0 || iz + i + 1 == baseLengthZ) {
                        world.func_147465_d(ix + x + i, y, iz + z + i, block, metaData, 2);
                    } else if (isHollow && !world.func_147437_c(ix + x + i, y, iz + z + i)) {
                        world.func_147468_f(ix + x + i, y, iz + z + i);
                    }
                    ++iz;
                }
                ++ix;
            }
            --baseLengthX;
            --baseLengthZ;
            ++i;
        }
    }

    private void spawnIdolGuardians(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            for (byte spawn = 0; spawn < 4; spawn = (byte)(spawn + 1)) {
                EntityUmberGolemDungeonTypes entityUmberGolem = new EntityUmberGolemDungeonTypes(world);
                entityUmberGolem.setType(spawn);
                entityUmberGolem.func_70606_j(entityUmberGolem.func_110138_aP());
                switch (spawn) {
                    case 0: {
                        entityUmberGolem.func_70107_b((double)x + 2.5, (double)y - 3.0, (double)z + 2.5);
                        break;
                    }
                    case 1: {
                        entityUmberGolem.func_70107_b((double)x + 118.5, (double)y - 3.0, (double)z + 2.5);
                        break;
                    }
                    case 2: {
                        entityUmberGolem.func_70107_b((double)x + 118.5, (double)y - 3.0, (double)z + 118.5);
                        break;
                    }
                    case 3: {
                        entityUmberGolem.func_70107_b((double)x + 2.5, (double)y - 3.0, (double)z + 118.5);
                    }
                }
                world.func_72838_d((Entity)entityUmberGolem);
            }
        }
    }

    private void buildCourtyard(World world, Block block, int metaData, int x, int y, int z, int baseLengthX, int heightY, int baseLengthZ) {
        for (int yy = y; yy <= heightY + y; ++yy) {
            for (int xx = x - baseLengthX / 2; xx < x + baseLengthX / 2; ++xx) {
                for (int zz = z - baseLengthZ / 2; zz < z + baseLengthZ / 2; ++zz) {
                    int i;
                    if (yy <= y || yy > y + 4) continue;
                    if (!world.func_147437_c(xx, yy, zz)) {
                        world.func_147468_f(xx, yy, zz);
                    }
                    if ((xx == x - baseLengthX / 2 || xx == x + baseLengthX / 2 - 1) && zz > z - baseLengthZ / 2 && zz < z + baseLengthZ / 2) {
                        if (yy <= y + 3) {
                            for (i = 3; i < 49; i += 5) {
                                world.func_147465_d(xx, yy, z - baseLengthZ / 2 + i, block, metaData, 2);
                            }
                        }
                        if (yy == y + 4) {
                            for (i = 0; i < 52; ++i) {
                                world.func_147465_d(xx, yy, z - baseLengthZ / 2 + i, ModBlocks.templeBrick, 0, 2);
                            }
                        }
                    }
                    if (zz != z - baseLengthZ / 2 && zz != z + baseLengthZ / 2 - 1 || xx <= x - baseLengthX / 2 || xx >= x + baseLengthX / 2) continue;
                    if (yy <= y + 3) {
                        for (i = 3; i < 49; i += 5) {
                            world.func_147465_d(x - baseLengthZ / 2 + i, yy, zz, block, metaData, 2);
                        }
                    }
                    if (yy != y + 4) continue;
                    for (i = 0; i < 52; ++i) {
                        world.func_147465_d(x - baseLengthZ / 2 + i, yy, zz, ModBlocks.templeBrick, 0, 2);
                    }
                }
            }
        }
    }

    private void buildRoof(World world, int x, int y, int z, int w, int h, Random rand) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                if (!this.canPlaceFeatureAt(world, x, y, z, x + j, y, z + i)) continue;
                world.func_147465_d(x + j, y, z + i, this.solid, 3, 2);
            }
        }
    }

    private void buildFloor(World world, int x, int y, int z, int w, int h, Random rand) {
        this.createPyramid(world, Blocks.field_150350_a, 0, true, x + 36, z + 36, 48, 48, y + 5);
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                if (rand.nextInt(15) == 0) {
                    if (rand.nextBoolean() && rand.nextBoolean()) {
                        world.func_147449_b(x + j, y, z + i, Blocks.field_150353_l);
                        continue;
                    }
                    world.func_147449_b(x + j, y, z + i, ModBlocks.gneissVent);
                    continue;
                }
                world.func_147465_d(x + j, y, z + i, this.solid, 5, 2);
            }
        }
    }

    private void addFeature(World world, int x, int y, int z, int w, int h, int[][] maze, Random rand) {
        for (int i = 0; i < h; ++i) {
            int j;
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) != 0) continue;
                if (rand.nextInt(25) == 0 && this.canPlaceFeatureAt(world, x, y, z, x + 1 + j * 4, y - 1, z + 1 + i * 4)) {
                    world.func_147465_d(x + 1 + j * 4, y, z + 1 + i * 4, Blocks.field_150478_aa, 3, 2);
                    if (rand.nextInt(4) == 0) {
                        this.placeChest(world, x + 1 + j * 4, y - 1, z + 1 + i * 4, 3, rand);
                        continue;
                    }
                    if (rand.nextInt(6) != 0) continue;
                    this.placeBones(world, x + 1 + j * 4, y - 1, z + 1 + i * 4, 3, rand);
                    continue;
                }
                if (rand.nextInt(10) != 0) continue;
                if (rand.nextBoolean()) {
                    world.func_147449_b(x + 2 + j * 4, y - 2, z + 2 + i * 4, ModBlocks.antlionSpawner);
                    continue;
                }
                world.func_147449_b(x + 2 + j * 4, y + 2, z + 2 + i * 4, ModBlocks.magmaCrawlerSpawner);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 8) != 0 || rand.nextInt(25) != 0 || !this.canPlaceFeatureAt(world, x, y, z, x + 1 + j * 4, y - 1, z + 2 + i * 4)) continue;
                world.func_147465_d(x + 1 + j * 4, y, z + 2 + i * 4, Blocks.field_150478_aa, 1, 2);
                if (rand.nextInt(4) == 0) {
                    this.placeChest(world, x + 1 + j * 4, y - 1, z + 2 + i * 4, 1, rand);
                    continue;
                }
                if (rand.nextInt(6) != 0) continue;
                this.placeBones(world, x + 1 + j * 4, y - 1, z + 2 + i * 4, 5, rand);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 4) != 0 || rand.nextInt(25) != 0 || !this.canPlaceFeatureAt(world, x, y, z, x + 3 + j * 4, y - 1, z + 2 + i * 4)) continue;
                world.func_147465_d(x + 3 + j * 4, y, z + 2 + i * 4, Blocks.field_150478_aa, 2, 2);
                if (rand.nextInt(4) == 0) {
                    this.placeChest(world, x + 3 + j * 4, y - 1, z + 2 + i * 4, 2, rand);
                    continue;
                }
                if (rand.nextInt(6) != 0) continue;
                this.placeBones(world, x + 3 + j * 4, y - 1, z + 2 + i * 4, 4, rand);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 2) != 0 || rand.nextInt(25) != 0 || !this.canPlaceFeatureAt(world, x, y, z, x + 2 + j * 4, y - 1, z + 3 + i * 4)) continue;
                world.func_147465_d(x + 2 + j * 4, y, z + 3 + i * 4, Blocks.field_150478_aa, 4, 2);
                if (rand.nextInt(4) == 0) {
                    this.placeChest(world, x + 2 + j * 4, y - 1, z + 3 + i * 4, 4, rand);
                    continue;
                }
                if (rand.nextInt(6) != 0) continue;
                this.placeBones(world, x + 2 + j * 4, y - 1, z + 3 + i * 4, 2, rand);
            }
        }
    }

    private void placeChest(World world, int x, int y, int z, int directionMeta, Random rand) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, directionMeta, 2);
        TileEntityChest chest = (TileEntityChest)world.func_147438_o(x, y, z);
        if (chest != null) {
            LootUtil.generateLoot((IInventory)chest, rand, chestLoot, 3, 10);
        }
    }

    private void placeBones(World world, int x, int y, int z, int directionMeta, Random rand) {
        world.func_147465_d(x, y, z, ModBlocks.bones, directionMeta, 2);
        TileEntityBones bones = (TileEntityBones)world.func_147438_o(x, y, z);
        if (bones != null) {
            LootUtil.generateLoot((IInventory)bones, rand, chestLoot, 3, 10);
        }
    }

    private boolean canPlaceFeatureAt(World world, int x, int y, int z, int featureX, int featureY, int featureZ) {
        for (int xx = x + 34; xx < x + 86; ++xx) {
            for (int zz = z + 34; zz < z + 86; ++zz) {
                if (featureX != xx || featureZ != zz) continue;
                return false;
            }
        }
        return true;
    }

    private void buildLevel(World world, int x, int y, int z, int w, int h, int[][] maze, Block blockType, int blockMeta) {
        for (int i = 0; i < h; ++i) {
            int j;
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) == 0) {
                    world.func_147465_d(x + j * 4, y, z + i * 4, blockType, blockMeta, 2);
                    world.func_147465_d(x + j * 4 + 1, y, z + i * 4, blockType, blockMeta, 2);
                    world.func_147465_d(x + j * 4 + 2, y, z + i * 4, blockType, blockMeta, 2);
                    world.func_147465_d(x + j * 4 + 3, y, z + i * 4, blockType, blockMeta, 2);
                    continue;
                }
                world.func_147465_d(x + j * 4, y, z + i * 4, blockType, blockMeta, 2);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 8) != 0) continue;
                world.func_147465_d(x + j * 4, y, z + i * 4 + 1, blockType, blockMeta, 2);
                world.func_147465_d(x + j * 4, y, z + i * 4 + 2, blockType, blockMeta, 2);
                world.func_147465_d(x + j * 4, y, z + i * 4 + 3, blockType, blockMeta, 2);
            }
            world.func_147465_d(x + w * 4, y, z + i * 4, blockType, blockMeta, 2);
            world.func_147465_d(x + w * 4, y, z + i * 4 + 1, blockType, blockMeta, 2);
            world.func_147465_d(x + w * 4, y, z + i * 4 + 2, blockType, blockMeta, 2);
            world.func_147465_d(x + w * 4, y, z + i * 4 + 3, blockType, blockMeta, 2);
        }
        for (int j = 0; j <= w * 4; ++j) {
            world.func_147465_d(x + j, y, z + h * 4, blockType, blockMeta, 2);
        }
    }

    public static void breakForceField(World world, int x, int y, int z) {
        for (int d = 0; d < 4; ++d) {
            for (int wx = 0 + d; wx < 9; ++wx) {
                world.func_147468_f(x + 11 + wx, y + d, z + 21);
                world.func_147468_f(x + 11 + wx, y + d, z + 22);
                world.func_147468_f(x + 21, y + d, z + 11 + wx);
                world.func_147468_f(x + 22, y + d, z + 11 + wx);
                world.func_147468_f(x + 21, y + d, z + 32 - wx);
                world.func_147468_f(x + 22, y + d, z + 32 - wx);
                world.func_147468_f(x + 32 - wx, y + d, z + 21);
                world.func_147468_f(x + 32 - wx, y + d, z + 22);
            }
            for (int dx = x + 20; dx < x + 24; ++dx) {
                for (int dz = z + 20; dz < z + 24; ++dz) {
                    if (world.func_147437_c(dx, y + d, dz)) continue;
                    world.func_72889_a(null, 2001, dx, y + d, dz, Block.func_149682_b((Block)world.func_147439_a(dx, y + d, dz)));
                    world.func_147468_f(dx, y + d, dz);
                }
            }
        }
        world.func_147465_d(x + 20, y, z + 20, ModBlocks.bambooTorch, 0, 3);
        world.func_147465_d(x + 20, y + 1, z + 20, ModBlocks.bambooTorch, 1, 3);
        world.func_147465_d(x + 20, y, z + 23, ModBlocks.bambooTorch, 0, 3);
        world.func_147465_d(x + 20, y + 1, z + 23, ModBlocks.bambooTorch, 1, 3);
        world.func_147465_d(x + 23, y, z + 23, ModBlocks.bambooTorch, 0, 3);
        world.func_147465_d(x + 23, y + 1, z + 23, ModBlocks.bambooTorch, 1, 3);
        world.func_147465_d(x + 23, y, z + 20, ModBlocks.bambooTorch, 0, 3);
        world.func_147465_d(x + 23, y + 1, z + 20, ModBlocks.bambooTorch, 1, 3);
        EntityAntlionBoss antlionboss = new EntityAntlionBoss(world);
        antlionboss.func_70107_b(x + 21, y - 8, z + 21);
        antlionboss.setInPyramid((byte)1);
        antlionboss.setSpawnPoint(x + 21, y - 8, z + 21);
        world.func_72838_d((Entity)antlionboss);
    }
}

