/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.decoration;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.core.helper.Utils;
import erebus.item.ItemSpawnEggs;
import erebus.tileentity.TileEntityPreservedBlock;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAmberGround
extends WorldGenerator {
    private static final float BUGGED_AMBER_CHANCE = 0.01f;
    private static final float WAND_CHANCE = 0.05f;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        boolean plausible = false;
        for (int a = 0; a < 10; ++a) {
            if (world.func_147437_c(x, y, z) && world.func_147439_a(x, y - 1, z) == Blocks.field_150349_c) {
                plausible = true;
                break;
            }
            if (--y > 1) continue;
            return false;
        }
        if (!plausible) {
            return false;
        }
        float rad = rand.nextFloat() + 2.6f;
        int ceilRad = 1 + (int)Math.ceil(rad);
        for (int xx = -ceilRad; xx <= ceilRad; ++xx) {
            for (int yy = -ceilRad; yy <= ceilRad; ++yy) {
                for (int zz = -ceilRad; zz <= ceilRad; ++zz) {
                    if (!(Math.sqrt(xx * xx + yy * yy + zz * zz) <= (double)(rad + rand.nextFloat() * 0.4f))) continue;
                    this.setBlock(world, x + xx, y + yy, z + zz, rand);
                }
            }
        }
        return true;
    }

    protected void setBlock(World world, int x, int y, int z, Random rand) {
        if (rand.nextFloat() > 0.01f) {
            world.func_147449_b(x, y, z, ModBlocks.amber);
        } else {
            world.func_147465_d(x, y, z, ModBlocks.preservedBlock, 6 + rand.nextInt(4), 3);
            TileEntityPreservedBlock tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityPreservedBlock.class);
            if (tile != null) {
                try {
                    EntityItem entity;
                    if (rand.nextFloat() > 0.05f) {
                        Class<? extends EntityLiving> cls = ItemSpawnEggs.getRandomEntityClass();
                        entity = (Entity)cls.getConstructor(World.class).newInstance(world);
                    } else {
                        EntityItem item = new EntityItem(world);
                        item.func_92058_a(new ItemStack(ModItems.wandOfPreservation));
                        entity = item;
                    }
                    entity.func_70107_b((double)x, (double)y, (double)z);
                    world.func_72838_d((Entity)entity);
                    NBTTagCompound nbt = new NBTTagCompound();
                    entity.func_70109_d(nbt);
                    nbt.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
                    tile.setEntityNBT(nbt);
                    entity.func_70106_y();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

