/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenAmberGround;
import erebus.world.feature.decoration.WorldGenAmberUmberstone;
import erebus.world.feature.decoration.WorldGenPonds;
import erebus.world.feature.decoration.WorldGenRottenAcacia;
import erebus.world.feature.decoration.WorldGenSavannahRock;
import erebus.world.feature.plant.WorldGenBamboo;
import erebus.world.feature.tree.WorldGenAsperTree;
import erebus.world.feature.tree.WorldGenBaobabTree;
import erebus.world.feature.tree.WorldGenGiantBaobab;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeDecoratorSubterraneanSavannah
extends BiomeDecoratorBaseErebus {
    private final WorldGenPonds genPonds = new WorldGenPonds();
    private final WorldGenBamboo genBamboo = new WorldGenBamboo(7, true);
    private final WorldGenSavannahRock genRocks = new WorldGenSavannahRock();
    private final WorldGenRottenAcacia genRottenAcacia = new WorldGenRottenAcacia();
    private final WorldGenAmberGround genAmberGround = new WorldGenAmberGround();
    private final WorldGenAmberUmberstone genAmberUmberstone = new WorldGenAmberUmberstone();
    private final WorldGenGiantBaobab genGiantBaobab = new WorldGenGiantBaobab();
    private final WorldGenTallGrass genGrass = new WorldGenTallGrass((Block)Blocks.field_150329_H, 1);
    private final WorldGenerator genTreeAcacia = new WorldGenSavannaTree(true);
    private final WorldGenerator genTreeAsper = new WorldGenAsperTree();
    private final WorldGenerator genTreeBaobab = new WorldGenBaobabTree();

    @Override
    public void populate() {
        if (this.rand.nextBoolean() && this.rand.nextBoolean()) {
            this.attempt = 0;
            while (this.attempt < 8) {
                this.xx = this.x + 16;
                this.yy = this.rand.nextInt(120);
                this.zz = this.z + 16;
                if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                    this.genPonds.prepare((this.rand.nextDouble() + 0.75) * 1.2);
                    this.genPonds.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
                }
                ++this.attempt;
            }
            if (this.rand.nextInt(3) != 0) {
                this.yy = 100;
                while (this.yy > 20) {
                    this.xx = this.x + this.offsetXZ();
                    this.zz = this.z + this.offsetXZ();
                    if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                        this.genBamboo.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
                    }
                    --this.yy;
                }
            }
        }
    }

    @Override
    public void decorate() {
        this.xx = this.x + 16;
        this.yy = 16;
        this.zz = this.z + 16;
        for (int yUp = this.yy; 64 + this.yy >= yUp; ++yUp) {
            if ((!this.checkSurface(SurfaceType.GRASS, this.xx, yUp, this.zz) || !this.checkSurface(SurfaceType.GRASS, this.xx - 6, yUp, this.zz - 6) || !this.checkSurface(SurfaceType.GRASS, this.xx + 6, yUp, this.zz + 6)) && (!this.checkSurface(SurfaceType.GRASS, this.xx, yUp, this.zz) || !this.checkSurface(SurfaceType.GRASS, this.xx + 6, yUp, this.zz - 6) || !this.checkSurface(SurfaceType.GRASS, this.xx - 6, yUp, this.zz + 6))) continue;
            this.genGiantBaobab.func_76484_a(this.world, this.rand, this.xx, yUp, this.zz);
            break;
        }
        if (this.rand.nextInt(12) == 0) {
            this.attempt = 0;
            while (this.attempt < 5 && !this.genAmberUmberstone.func_76484_a(this.world, this.rand, this.x + this.offsetXZ(), this.rand.nextInt(120), this.z + this.offsetXZ())) {
                ++this.attempt;
            }
        }
        if (this.rand.nextInt(24) == 0) {
            this.attempt = 0;
            while (this.attempt < 4 && !this.genAmberGround.func_76484_a(this.world, this.rand, this.x + this.offsetXZ(), 10 + this.rand.nextInt(40), this.z + this.offsetXZ())) {
                ++this.attempt;
            }
        }
        this.attempt = 0;
        while (this.attempt < 65) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                this.genTreeAcacia.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        if (this.rand.nextBoolean() && this.rand.nextBoolean()) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 100;
            while (this.yy > 20) {
                if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                    this.genRocks.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
                }
                --this.yy;
            }
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                this.genTreeAsper.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 20) {
            this.xx = this.x + this.rand.nextInt(13) + 9;
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.rand.nextInt(13) + 9;
            if (this.checkSurface(SurfaceType.GRASS, this.xx - 2, this.yy, this.zz - 2) && this.checkSurface(SurfaceType.GRASS, this.xx + 2, this.yy, this.zz + 2) && this.checkSurface(SurfaceType.GRASS, this.xx + 2, this.yy, this.zz - 2) && this.checkSurface(SurfaceType.GRASS, this.xx - 2, this.yy, this.zz + 2)) {
                this.genTreeBaobab.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 28) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                this.genRottenAcacia.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 180) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz)) {
                this.genGrass.func_76484_a(this.world, this.rand, this.xx, this.yy, this.zz);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 40) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            if (this.checkSurface(SurfaceType.GRASS, this.xx, this.yy, this.zz) && this.world.func_147437_c(this.xx, this.yy + 1, this.zz)) {
                this.world.func_147465_d(this.xx, this.yy, this.zz, (Block)Blocks.field_150398_cm, 2, 2);
                this.world.func_147465_d(this.xx, this.yy + 1, this.zz, (Block)Blocks.field_150398_cm, 10, 2);
            }
            ++this.attempt;
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case GOLD: {
                oreGen.setChance(0.75f).setIterations(extraOres ? 1 : 2).setY(50, 126).generate(this.world, this.rand, this.x, this.z);
                oreGen.setChance(0.9f).setIterations(extraOres ? 1 : 2, extraOres ? 2 : 3).setY(25, 50).generate(this.world, this.rand, this.x, this.z);
                oreGen.setIterations(extraOres ? 2 : 3, extraOres ? 3 : 4).setY(5, 25);
                break;
            }
            case EMERALD: {
                oreGen.setChance(0.22f);
                break;
            }
            case DIAMOND: {
                oreGen.setChance(0.4f).setIterations(1, 2).setOreAmount(2).setY(5, 16);
                break;
            }
            case JADE: {
                oreGen.setChance(0.3f).setIterations(0, 3);
                break;
            }
            case PETRIFIED_WOOD: {
                oreGen.setChance(0.5f).setIterations(0, extraOres ? 2 : 3).setY(5, 64);
            }
        }
    }
}

