/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.world.biomes.decorators.data.FeatureType;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenRedGem;
import java.util.Random;
import net.minecraft.world.World;

public abstract class BiomeDecoratorBaseErebus {
    protected World world;
    protected Random rand;
    protected int x;
    protected int z;
    protected int xx;
    protected int yy;
    protected int zz;
    protected int attempt;
    private boolean isDecorating = false;
    private static final OreSettings oreGen = new OreSettings();
    protected static final WorldGenRedGem genRedGem = new WorldGenRedGem();

    protected BiomeDecoratorBaseErebus() {
    }

    public final void populate(World world, Random rand, int x, int z) {
        this.world = world;
        this.rand = rand;
        this.x = x;
        this.z = z;
        this.populate();
    }

    public final void decorate(World world, Random rand, int x, int z) {
        if (this.isDecorating) {
            throw new RuntimeException("Already decorating Erebus!");
        }
        this.isDecorating = true;
        this.world = world;
        this.rand = rand;
        this.x = x;
        this.z = z;
        for (FeatureType featureType : FeatureType.values()) {
            this.generateFeature(featureType);
        }
        boolean extraOres = OreSettings.OreType.LEAD.isEnabled() || OreSettings.OreType.SILVER.isEnabled() || OreSettings.OreType.COPPER.isEnabled() || OreSettings.OreType.TIN.isEnabled() || OreSettings.OreType.ALUMINIUM.isEnabled();
        for (OreSettings.OreType oreType : OreSettings.OreType.values()) {
            if (!oreType.isEnabled()) continue;
            oreType.setupDefault(oreGen, extraOres);
            this.modifyOreGen(oreGen, oreType, extraOres);
            oreGen.generate(world, rand, x, z);
        }
        this.decorate();
        this.isDecorating = false;
    }

    protected void populate() {
    }

    protected void decorate() {
    }

    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
    }

    protected void generateFeature(FeatureType featureType) {
        switch (featureType) {
            case REDGEM: {
                this.attempt = 0;
                while (this.attempt < 5) {
                    genRedGem.func_76484_a(this.world, this.rand, this.x + this.offsetXZ(), 64 + this.rand.nextInt(60), this.z + this.offsetXZ());
                    ++this.attempt;
                }
                break;
            }
        }
    }

    protected final int offsetXZ() {
        return this.rand.nextInt(16) + 8;
    }

    protected boolean checkSurface(SurfaceType surfaceType, int x, int y, int z) {
        return surfaceType.matchBlock(this.world.func_147439_a(x, y - 1, z)) && this.world.func_147437_c(x, y, z);
    }

    public static class BiomeDecoratorEmpty
    extends BiomeDecoratorBaseErebus {
    }
}

