/*
 * Decompiled with CFR 0.152.
 */
package erebus.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.ChunkProviderErebus;
import erebus.world.WorldChunkManagerErebus;
import erebus.world.biomes.BiomeBaseErebus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldProviderErebus
extends WorldProvider {
    @SideOnly(value=Side.CLIENT)
    private double[] currentFogColor;
    @SideOnly(value=Side.CLIENT)
    private short[] targetFogColor;
    private boolean allowHostiles;
    private boolean allowAnimals;

    public boolean func_76567_e() {
        return ConfigHandler.INSTANCE.allowRespawning;
    }

    public boolean func_76566_a(int x, int z) {
        return this.field_76579_a.func_147474_b(x, z) != Blocks.field_150357_h && this.field_76579_a.func_147474_b(x, z) != Blocks.field_150350_a;
    }

    public float func_76563_a(long worldTime, float partialTickTime) {
        return 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float celestialAngle, float partialTickTime) {
        int a;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        BiomeGenBase biome = this.field_76579_a.func_72807_a((int)player.field_70165_t, (int)player.field_70161_v);
        this.targetFogColor = biome instanceof BiomeBaseErebus ? ((BiomeBaseErebus)biome).getFogRGB() : new short[]{255, 255, 255};
        if (this.currentFogColor == null) {
            this.currentFogColor = new double[3];
            for (a = 0; a < 3; ++a) {
                this.currentFogColor[a] = this.targetFogColor[a];
            }
        }
        for (a = 0; a < 3; ++a) {
            if (this.currentFogColor[a] == (double)this.targetFogColor[a]) continue;
            if (this.currentFogColor[a] < (double)this.targetFogColor[a]) {
                int n = a;
                this.currentFogColor[n] = this.currentFogColor[n] + 2.0;
                if (!(this.currentFogColor[a] > (double)this.targetFogColor[a])) continue;
                this.currentFogColor[a] = this.targetFogColor[a];
                continue;
            }
            if (!(this.currentFogColor[a] > (double)this.targetFogColor[a])) continue;
            int n = a;
            this.currentFogColor[n] = this.currentFogColor[n] - 2.0;
            if (!(this.currentFogColor[a] < (double)this.targetFogColor[a])) continue;
            this.currentFogColor[a] = this.targetFogColor[a];
        }
        return Vec3.func_72443_a((double)(this.currentFogColor[0] / 255.0), (double)(this.currentFogColor[1] / 255.0), (double)(this.currentFogColor[2] / 255.0));
    }

    protected void func_76556_a() {
        float f = 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    public void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerErebus(this.field_76579_a);
        this.field_76576_e = true;
        this.field_76574_g = ConfigHandler.INSTANCE.erebusDimensionID;
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderErebus(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public boolean func_76569_d() {
        return false;
    }

    public int getActualHeight() {
        return 128;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public void setAllowedSpawnTypes(boolean allowHostiles, boolean allowAnimals) {
        this.allowHostiles = allowHostiles;
        this.allowAnimals = allowAnimals;
        super.setAllowedSpawnTypes(allowHostiles, allowAnimals);
    }

    public boolean getCanSpawnHostiles() {
        return this.allowHostiles;
    }

    public boolean getCanSpawnAnimals() {
        return this.allowAnimals;
    }

    public String func_80007_l() {
        return "Erebus";
    }

    public ChunkCoordinates getRandomizedSpawnPoint() {
        ChunkCoordinates chunkcoordinates = new ChunkCoordinates(this.field_76579_a.func_72861_E());
        boolean isAdventure = this.field_76579_a.func_72912_H().func_76077_q() == WorldSettings.GameType.ADVENTURE;
        int spawnFuzz = 100;
        int spawnFuzzHalf = spawnFuzz / 2;
        if (!this.field_76576_e && !isAdventure) {
            chunkcoordinates.field_71574_a += this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
            chunkcoordinates.field_71573_c += this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
            chunkcoordinates.field_71572_b = this.field_76579_a.func_72825_h(chunkcoordinates.field_71574_a, chunkcoordinates.field_71573_c);
        }
        return chunkcoordinates;
    }
}

