/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.block.BlockUmberFurnace;
import erebus.inventory.ContainerUmberFurnace;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityUmberFurnace
extends TileEntityBasicInventory
implements IFluidHandler {
    private final FluidTank tank = new FluidTank(16000);
    private final int BUCKET_SLOT = 0;
    private final int SMELT_SLOT = 1;
    private final int FUEL_SLOT = 2;
    private final int RESULT_SLOT = 3;
    private final int COOK_TIME_BASE = 200;
    private int cookTime = 200;
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int furnaceCookTime;
    private int prevFurnaceCookTime;

    public TileEntityUmberFurnace() {
        super(4, "container.umberFurnace");
        this.tank.setFluid(new FluidStack(FluidRegistry.LAVA, 0));
    }

    public ItemStack fillTankWithBucket(ItemStack bucket) {
        if (this.tank.getFluidAmount() <= this.tank.getCapacity() - 1000 && FluidContainerRegistry.isFilledContainer((ItemStack)bucket) && FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket).getFluid() == FluidRegistry.LAVA && bucket.field_77994_a == 1) {
            this.tank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data.filledContainer.func_77973_b() != bucket.func_77973_b() || data.filledContainer.func_77960_j() != bucket.func_77960_j()) continue;
                return data.emptyContainer.func_77946_l();
            }
        }
        return bucket;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.prevFurnaceCookTime = this.furnaceCookTime;
            return;
        }
        this.inventory[0] = this.fillTankWithBucket(this.inventory[0]);
        this.cookTime = 200 - (int)(160.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[2]);
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.inventory[2] != null) {
                        --this.inventory[2].field_77994_a;
                        if (this.inventory[2].field_77994_a == 0) {
                            this.inventory[2] = this.inventory[2].func_77973_b().getContainerItem(this.inventory[2]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime >= this.cookTime) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                boolean tileActive = this.furnaceBurnTime > 0;
                int meta = this.func_145832_p();
                boolean blockActive = BlockUmberFurnace.isActive(meta);
                if (blockActive && !tileActive) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta & 7, 3);
                }
                if (!blockActive && tileActive) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta | 8, 3);
                }
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.inventory[1] == null) {
            return false;
        }
        ItemStack is = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory[1]);
        if (is == null) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[3].func_77969_a(is)) {
            return false;
        }
        int result = this.inventory[3].field_77994_a + is.field_77994_a;
        return result <= this.func_70297_j_() && result <= is.func_77976_d();
    }

    private void smeltItem() {
        if (this.canSmelt()) {
            ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory[1]);
            if (this.inventory[3] == null) {
                this.inventory[3] = stack.func_77946_l();
            } else if (this.inventory[3].func_77969_a(stack)) {
                this.inventory[3].field_77994_a += stack.field_77994_a;
            }
            this.tank.drain(100, true);
            --this.inventory[1].field_77994_a;
            if (this.inventory[1].field_77994_a <= 0) {
                this.inventory[1] = null;
            }
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 ? FluidContainerRegistry.isContainer((ItemStack)is) : (slot == 2 ? TileEntityFurnace.func_145954_b((ItemStack)is) : (slot == 1 ? FurnaceRecipes.func_77602_a().func_151395_a(is) != null : false));
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 3;
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 1;
        }
        return nArray;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 0 ? FluidContainerRegistry.isEmptyContainer((ItemStack)is) : true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != FluidRegistry.LAVA) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getScaledFluidAmount(float scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().amount / (float)this.tank.getCapacity() * scale) : 0;
    }

    public String getFluidAmount() {
        return this.tank.getFluidAmount() + " mB";
    }

    public void getGUIData(int id, int value) {
        switch (id) {
            case 1: {
                if (this.tank.getFluid() == null) {
                    this.tank.setFluid(new FluidStack(FluidRegistry.LAVA, value));
                    break;
                }
                this.tank.getFluid().amount = value;
                break;
            }
            case 2: {
                this.furnaceBurnTime = value;
                break;
            }
            case 3: {
                this.furnaceCookTime = value;
                break;
            }
            case 4: {
                this.cookTime = value;
                break;
            }
            case 5: {
                this.currentItemBurnTime = value;
            }
        }
    }

    public void sendGUIData(ContainerUmberFurnace furnace, ICrafting craft) {
        craft.func_71112_a((Container)furnace, 1, this.tank.getFluid() != null ? this.tank.getFluid().amount : 0);
        craft.func_71112_a((Container)furnace, 2, this.furnaceBurnTime);
        craft.func_71112_a((Container)furnace, 3, this.furnaceCookTime);
        craft.func_71112_a((Container)furnace, 4, this.cookTime);
        craft.func_71112_a((Container)furnace, 5, this.currentItemBurnTime);
    }

    @SideOnly(value=Side.CLIENT)
    public float getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.cookTime;
        }
        return (float)(this.furnaceBurnTime * scale) / (float)this.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCookProgressScaled(int scale) {
        return (float)(this.furnaceCookTime * scale) / (float)this.cookTime;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPrevCookProgressScaled(int scale) {
        return (float)(this.prevFurnaceCookTime * scale) / (float)this.cookTime;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
        this.currentItemBurnTime = data.func_74762_e("currentItemBurnTime");
        this.furnaceBurnTime = data.func_74762_e("furnaceBurnTime");
        this.furnaceCookTime = data.func_74762_e("furnaceCookTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
        data.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        data.func_74768_a("furnaceBurnTime", this.furnaceBurnTime);
        data.func_74768_a("furnaceCookTime", this.furnaceCookTime);
    }
}

