/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.recipes.SmoothieMakerRecipe;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntitySmoothieMaker
extends TileEntityBasicInventory
implements IFluidHandler {
    private static final int MAX_TIME = 432;
    private final FluidTank[] tanks = new FluidTank[4];
    private int progress = 0;
    private int prevProgress = 0;

    public TileEntitySmoothieMaker() {
        super(5, "container.kitchenCounter");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(16000);
        }
    }

    public FluidTank[] getTanks() {
        return this.tanks;
    }

    public float getBlendProgress() {
        return (float)this.progress / 12.0f;
    }

    public float getPrevBlendProgress() {
        return (float)this.prevProgress / 12.0f;
    }

    public boolean isBlending() {
        return this.progress > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        if (nbt.func_74764_b("honeyTank")) {
            this.tanks[0].readFromNBT(nbt.func_74775_l("honeyTank"));
            this.tanks[1].readFromNBT(nbt.func_74775_l("milkTank"));
            this.tanks[2].readFromNBT(nbt.func_74775_l("beetleTank"));
            this.tanks[3].readFromNBT(nbt.func_74775_l("antiVenomTank"));
        } else {
            this.readTanksFromNBT(nbt);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        this.writeTanksToNBT(nbt);
    }

    private void writeTanksToNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.tanks.length; ++i) {
            nbt.func_74782_a("tank_" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
        }
    }

    private void readTanksFromNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt.func_74775_l("tank_" + i));
        }
    }

    public void writeGUIData(NBTTagCompound nbt) {
        nbt.func_74768_a("progress", this.progress);
        this.writeTanksToNBT(nbt);
    }

    public void readGUIData(NBTTagCompound nbt) {
        this.progress = nbt.func_74762_e("progress");
        this.readTanksFromNBT(nbt);
    }

    public ItemStack fillTankWithBucket(ItemStack bucket) {
        int amountFilled;
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket);
        if (fluid != null && this.canFill(ForgeDirection.UNKNOWN, fluid.getFluid()) && (amountFilled = this.fill(ForgeDirection.UNKNOWN, fluid, false)) == fluid.amount) {
            this.fill(ForgeDirection.UNKNOWN, fluid, true);
            return FluidContainerRegistry.drainFluidContainer((ItemStack)bucket);
        }
        return bucket;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.prevProgress = this.progress;
            return;
        }
        ItemStack[] inputs = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            inputs[i] = this.inventory[i];
        }
        SmoothieMakerRecipe recipe = SmoothieMakerRecipe.getRecipe(this.func_70301_a(4), (IFluidTank)this.tanks[0], (IFluidTank)this.tanks[1], (IFluidTank)this.tanks[2], (IFluidTank)this.tanks[3], inputs);
        if (recipe != null) {
            ++this.progress;
            if (this.progress >= 432) {
                for (int i = 0; i < 5; ++i) {
                    if (this.inventory[i] == null || --this.inventory[i].field_77994_a > 0) continue;
                    this.inventory[i] = null;
                }
                this.extractFluids(recipe);
                this.inventory[4] = ItemStack.func_77944_b((ItemStack)recipe.getOutput());
                this.progress = 0;
                this.func_70296_d();
            }
        }
        if (recipe == null || this.func_70301_a(4) == null) {
            this.progress = 0;
            this.func_70296_d();
        }
    }

    private void extractFluids(SmoothieMakerRecipe recipe) {
        block0: for (FluidStack fluid : recipe.getFluids()) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() == null || !tank.getFluid().isFluidEqual(fluid)) continue;
                tank.drain(fluid.amount, true);
                continue block0;
            }
        }
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource = resource.copy();
        int amountFilled = 0;
        boolean foundTankWithSameFluid = false;
        for (FluidTank tank : this.tanks) {
            if (!resource.isFluidEqual(tank.getFluid())) continue;
            foundTankWithSameFluid = true;
            amountFilled = tank.fill(resource, doFill);
            break;
        }
        resource.amount -= amountFilled;
        if (!foundTankWithSameFluid && amountFilled < resource.amount) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() != null) continue;
                amountFilled += tank.fill(resource, doFill);
                break;
            }
        }
        return amountFilled;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        for (SmoothieMakerRecipe recipe : SmoothieMakerRecipe.getRecipeList()) {
            for (FluidStack recipeFluid : recipe.getFluids()) {
                if (recipeFluid.getFluid() != fluid) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] infos = new FluidTankInfo[this.tanks.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FluidTankInfo(this.tanks[i].getFluid(), this.tanks[i].getCapacity());
        }
        return infos;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 4;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
    }
}

