/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.ModBlocks;
import erebus.core.helper.Utils;
import erebus.tileentity.TileEntityCompletedPuzzle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySlidingBlockPuzzle
extends TileEntity {
    private ForgeDirection facing;
    private BlockOffset offset;
    private SlidingPuzzle puzzle;
    private final SlidingPiece[] pieces = new SlidingPiece[4];
    private final SlidingPiece[] originalPieces = new SlidingPiece[4];
    private static Map<ForgeDirection, List<BlockOffset>> map = new HashMap<ForgeDirection, List<BlockOffset>>();

    public ForgeDirection getFacing() {
        return this.facing;
    }

    public BlockOffset getOffset() {
        return this.offset;
    }

    public SlidingPuzzle getPuzzle() {
        return this.puzzle;
    }

    public SlidingPiece[] getPieces() {
        return this.pieces;
    }

    public void onPuzzleChange() {
        for (int i = 0; i < this.pieces.length; ++i) {
            if (this.originalPieces[i].equals(this.pieces[i])) continue;
            return;
        }
        Utils.breakBlockWithParticles(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        ArrayList<ForgeDirection> neighbouringDirs = new ArrayList<ForgeDirection>();
        neighbouringDirs.add(ForgeDirection.UP);
        neighbouringDirs.add(ForgeDirection.DOWN);
        neighbouringDirs.add(this.facing.getRotation(ForgeDirection.UP));
        neighbouringDirs.add(this.facing.getRotation(ForgeDirection.DOWN));
        for (ForgeDirection dir : neighbouringDirs) {
            TileEntitySlidingBlockPuzzle neighbour;
            BlockOffset neighbourOffset = this.offset.add(dir);
            if (!neighbourOffset.isValid() || (neighbour = Utils.getTileEntity((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, TileEntitySlidingBlockPuzzle.class)) == null) continue;
            neighbour.onPuzzleChange();
        }
    }

    public boolean handleClick(float hitX, float hitY, float hitZ) {
        if (hitY > 0.5f) {
            switch (this.facing) {
                case NORTH: 
                case SOUTH: {
                    if (hitX > 0.5f) {
                        return this.handleClick(this.pieces[0]);
                    }
                    return this.handleClick(this.pieces[1]);
                }
                case WEST: 
                case EAST: {
                    if (hitZ > 0.5f) {
                        return this.handleClick(this.pieces[1]);
                    }
                    return this.handleClick(this.pieces[0]);
                }
            }
        } else {
            switch (this.facing) {
                case NORTH: 
                case SOUTH: {
                    if (hitX > 0.5f) {
                        return this.handleClick(this.pieces[2]);
                    }
                    return this.handleClick(this.pieces[3]);
                }
                case WEST: 
                case EAST: {
                    if (hitZ > 0.5f) {
                        return this.handleClick(this.pieces[3]);
                    }
                    return this.handleClick(this.pieces[2]);
                }
            }
        }
        return false;
    }

    private boolean handleClick(SlidingPiece piece) {
        if (piece.isEmpty()) {
            return false;
        }
        SlidingPiece emptyPiece = this.getEmptyPieceIfPresent();
        if (emptyPiece != null) {
            if (this.swapPiecesIfPossible(piece, emptyPiece)) {
                if (!this.field_145850_b.field_72995_K) {
                    this.onPuzzleChange();
                    Utils.sendUpdatesToClient(this.field_145850_b, this.func_145844_m());
                }
                return true;
            }
        } else {
            ArrayList<ForgeDirection> neighbouringDirs = new ArrayList<ForgeDirection>();
            neighbouringDirs.add(piece.index <= 1 ? ForgeDirection.UP : ForgeDirection.DOWN);
            neighbouringDirs.add(this.facing.getRotation(piece.index % 2 == 0 ? ForgeDirection.UP : ForgeDirection.DOWN));
            for (ForgeDirection dir : neighbouringDirs) {
                TileEntitySlidingBlockPuzzle neighbour;
                BlockOffset neighbourOffset = this.offset.add(dir);
                if (!neighbourOffset.isValid() || (neighbour = Utils.getTileEntity((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, TileEntitySlidingBlockPuzzle.class)) == null) continue;
                emptyPiece = neighbour.getEmptyPieceIfPresent();
                if (!neighbourOffset.equals(neighbour.offset) || emptyPiece == null || !this.swapPiecesIfPossible(piece, emptyPiece)) continue;
                if (!this.field_145850_b.field_72995_K) {
                    this.onPuzzleChange();
                    neighbour.onPuzzleChange();
                    Utils.sendUpdatesToClient(this.field_145850_b, this.func_145844_m());
                    Utils.sendUpdatesToClient(neighbour.field_145850_b, neighbour.func_145844_m());
                }
                return true;
            }
        }
        return false;
    }

    private SlidingPiece getEmptyPieceIfPresent() {
        for (SlidingPiece p : this.pieces) {
            if (!p.isEmpty()) continue;
            return p;
        }
        return null;
    }

    private boolean swapPiecesIfPossible(SlidingPiece piece, SlidingPiece emptyPiece) {
        if (piece.x == emptyPiece.x && piece.y != emptyPiece.y || piece.x != emptyPiece.x && piece.y == emptyPiece.y) {
            if (!this.field_145850_b.field_72995_K) {
                SlidingPiece.swapUVs(piece, emptyPiece);
            }
            return true;
        }
        return false;
    }

    public Packet func_145844_m() {
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, this.writeData(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 0) {
            this.readData(pkt.func_148857_g());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt);
    }

    private void readData(NBTTagCompound nbt) {
        int i;
        this.facing = ForgeDirection.getOrientation((int)nbt.func_74771_c("Facing"));
        this.offset = BlockOffset.fromArray(nbt.func_74759_k("Offset"));
        this.puzzle = SlidingPuzzle.values()[nbt.func_74762_e("Puzzle")];
        for (i = 0; i < this.pieces.length; ++i) {
            this.pieces[i] = SlidingPiece.fromArray(nbt.func_74759_k("Piece" + i));
        }
        for (i = 0; i < this.originalPieces.length; ++i) {
            this.originalPieces[i] = SlidingPiece.fromArray(nbt.func_74759_k("OriginalPiece" + i));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeData(nbt);
    }

    private NBTTagCompound writeData(NBTTagCompound nbt) {
        int i;
        if (this.facing != null) {
            nbt.func_74774_a("Facing", (byte)this.facing.ordinal());
        }
        if (this.offset != null) {
            nbt.func_74783_a("Offset", this.offset.toArray());
        }
        if (this.puzzle != null) {
            nbt.func_74768_a("Puzzle", this.puzzle.ordinal());
        }
        for (i = 0; i < this.pieces.length; ++i) {
            if (this.pieces[i] == null) continue;
            nbt.func_74783_a("Piece" + i, this.pieces[i].toArray());
        }
        for (i = 0; i < this.originalPieces.length; ++i) {
            if (this.originalPieces[i] == null) continue;
            nbt.func_74783_a("OriginalPiece" + i, this.originalPieces[i].toArray());
        }
        return nbt;
    }

    public static void createPuzzleAt(World world, int x, int y, int z, ForgeDirection facing, SlidingPuzzle puzzle) {
        TileEntityCompletedPuzzle compPuzzle;
        ArrayList<TileEntitySlidingBlockPuzzle> tiles = new ArrayList<TileEntitySlidingBlockPuzzle>();
        List<BlockOffset> offsets = map.get(facing);
        if (offsets == null) {
            throw new IllegalArgumentException("Can't generate sliding block puzzle facing " + facing);
        }
        if (facing == ForgeDirection.WEST) {
            world.func_147449_b(x, y, z - 2, ModBlocks.completedPuzzle);
        }
        if (facing == ForgeDirection.EAST) {
            world.func_147449_b(x, y, z + 2, ModBlocks.completedPuzzle);
        }
        if (facing == ForgeDirection.SOUTH) {
            world.func_147449_b(x - 2, y, z, ModBlocks.completedPuzzle);
        }
        if (facing == ForgeDirection.NORTH) {
            world.func_147449_b(x + 2, y, z, ModBlocks.completedPuzzle);
        }
        if ((compPuzzle = Utils.getTileEntity((IBlockAccess)world, x, y + 2, z, TileEntityCompletedPuzzle.class)) != null) {
            compPuzzle.setPuzzle(puzzle);
        }
        for (BlockOffset offset : offsets) {
            tiles.add(TileEntitySlidingBlockPuzzle.setBlock(world, x, y, z, offset, facing, puzzle));
        }
        ArrayList<SlidingPiece> pieces = new ArrayList<SlidingPiece>();
        for (int i = 0; i < tiles.size(); ++i) {
            TileEntitySlidingBlockPuzzle tile = (TileEntitySlidingBlockPuzzle)((Object)tiles.get(i));
            int tX = i % 3;
            int tY = i / 3;
            int xx = 2 * tX;
            int yy = 2 * tY;
            if (facing == ForgeDirection.SOUTH || facing == ForgeDirection.EAST) {
                tile.originalPieces[1] = new SlidingPiece(0, xx, yy);
                pieces.add(tile.originalPieces[1]);
                tile.originalPieces[0] = new SlidingPiece(1, xx + 1, yy);
                pieces.add(tile.originalPieces[0]);
                tile.originalPieces[3] = new SlidingPiece(2, xx, yy + 1);
                pieces.add(tile.originalPieces[3]);
                if (tX == 2 && tY == 2) {
                    tile.originalPieces[2] = new SlidingPiece(3, -1, -1);
                    pieces.add(tile.originalPieces[2]);
                    continue;
                }
                tile.originalPieces[2] = new SlidingPiece(3, xx + 1, yy + 1);
                pieces.add(tile.originalPieces[2]);
                continue;
            }
            tile.originalPieces[0] = new SlidingPiece(0, xx, yy);
            pieces.add(tile.originalPieces[0]);
            tile.originalPieces[1] = new SlidingPiece(1, xx + 1, yy);
            pieces.add(tile.originalPieces[1]);
            tile.originalPieces[2] = new SlidingPiece(2, xx, yy + 1);
            pieces.add(tile.originalPieces[2]);
            if (tX == 2 && tY == 2) {
                tile.originalPieces[3] = new SlidingPiece(3, -1, -1);
                pieces.add(tile.originalPieces[3]);
                continue;
            }
            tile.originalPieces[3] = new SlidingPiece(3, xx + 1, yy + 1);
            pieces.add(tile.originalPieces[3]);
        }
        for (TileEntitySlidingBlockPuzzle tile : tiles) {
            Random rand = tile.field_145850_b.field_73012_v;
            for (int i = 0; i < tile.pieces.length; ++i) {
                int index = rand.nextInt(pieces.size());
                int pieceIndex = i;
                if (facing == ForgeDirection.SOUTH || facing == ForgeDirection.EAST) {
                    pieceIndex ^= 1;
                }
                tile.pieces[i] = ((SlidingPiece)pieces.get(index)).copyUV(pieceIndex);
                pieces.remove(index);
            }
            Utils.sendUpdatesToClient(tile.field_145850_b, tile.func_145844_m());
        }
    }

    private static TileEntitySlidingBlockPuzzle setBlock(World world, int x, int y, int z, BlockOffset offset, ForgeDirection facing, SlidingPuzzle puzzle) {
        world.func_147449_b(x += offset.x, y += offset.y, z += offset.z, ModBlocks.slidingBlockPuzzle);
        TileEntitySlidingBlockPuzzle tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntitySlidingBlockPuzzle.class);
        tile.facing = facing;
        tile.offset = offset;
        tile.puzzle = puzzle;
        return tile;
    }

    static {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            ArrayList<BlockOffset> offsets = new ArrayList<BlockOffset>();
            switch (dir) {
                case EAST: {
                    int y;
                    for (y = 1; y >= -1; --y) {
                        offsets.add(new BlockOffset(0, y, 1));
                        offsets.add(new BlockOffset(0, y, 0));
                        offsets.add(new BlockOffset(0, y, -1));
                    }
                    break;
                }
                case NORTH: {
                    int y;
                    for (y = 1; y >= -1; --y) {
                        offsets.add(new BlockOffset(1, y, 0));
                        offsets.add(new BlockOffset(0, y, 0));
                        offsets.add(new BlockOffset(-1, y, 0));
                    }
                    break;
                }
                case SOUTH: {
                    int y;
                    for (y = 1; y >= -1; --y) {
                        offsets.add(new BlockOffset(-1, y, 0));
                        offsets.add(new BlockOffset(0, y, 0));
                        offsets.add(new BlockOffset(1, y, 0));
                    }
                    break;
                }
                case WEST: {
                    int y;
                    for (y = 1; y >= -1; --y) {
                        offsets.add(new BlockOffset(0, y, -1));
                        offsets.add(new BlockOffset(0, y, 0));
                        offsets.add(new BlockOffset(0, y, 1));
                    }
                    break;
                }
            }
            if (offsets.isEmpty()) continue;
            map.put(dir, offsets);
        }
    }

    public static enum SlidingPuzzle {
        TEST("erebus:textures/puzzles/test.png");

        public final String imagePath;

        private SlidingPuzzle(String imagePath) {
            this.imagePath = imagePath;
        }
    }

    public static class BlockOffset {
        public final int x;
        public final int y;
        public final int z;

        BlockOffset(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        int[] toArray() {
            return new int[]{this.x, this.y, this.z};
        }

        BlockOffset add(ForgeDirection dir) {
            return new BlockOffset(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
        }

        boolean isValid() {
            return this.x >= -1 && this.x <= 1 && this.y >= -1 && this.y <= 1 && this.z >= -1 && this.z <= 1;
        }

        static BlockOffset fromArray(int[] array) {
            return new BlockOffset(array[0], array[1], array[2]);
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockOffset) {
                BlockOffset off = (BlockOffset)obj;
                return off.x == this.x && off.y == this.y && off.z == this.z;
            }
            return false;
        }

        public String toString() {
            return "BlockOffset: " + this.x + ", " + this.y + ", " + this.z;
        }
    }

    public static class SlidingPiece {
        final int index;
        final int x;
        final int y;
        int u;
        int v;

        SlidingPiece(int index, int u, int v) {
            this.index = index;
            this.u = u;
            this.v = v;
            this.x = index % 2;
            this.y = index / 2;
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }

        public boolean isEmpty() {
            return this.u < 0 && this.v < 0;
        }

        int[] toArray() {
            return new int[]{this.index, this.u, this.v};
        }

        SlidingPiece copy() {
            return new SlidingPiece(this.index, this.u, this.v);
        }

        SlidingPiece copyUV(int index) {
            return new SlidingPiece(index, this.u, this.v);
        }

        static SlidingPiece fromArray(int[] array) {
            return new SlidingPiece(array[0], array[1], array[2]);
        }

        static void swapUVs(SlidingPiece piece0, SlidingPiece piece1) {
            SlidingPiece temp = piece0.copy();
            piece0.u = piece1.u;
            piece0.v = piece1.v;
            piece1.u = temp.u;
            piece1.v = temp.v;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SlidingPiece) {
                SlidingPiece piece = (SlidingPiece)obj;
                return piece.index == this.index && piece.u == this.u && piece.v == this.v;
            }
            return false;
        }

        public String toString() {
            return "SlidingPiece: index:" + this.index + ", u: " + this.u + ", v:" + this.v;
        }
    }
}

