/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.ModFluids;
import erebus.network.AbstractPacket;
import erebus.network.PacketPipeline;
import erebus.network.client.PacketJarOHoney;
import erebus.tileentity.TileEntityGlowingJar;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityJarOHoney
extends TileEntityGlowingJar {
    public static final int HONEY_MAX_AMOUNT = 4000;
    public final FluidTank tank = new FluidTank(ModFluids.honey, 0, 4000);
    private String owner = "Boo Boo";

    public int addHoney(int amount) {
        int result = this.tank.fill(FluidRegistry.getFluidStack((String)"honey", (int)amount), true);
        this.sendUpdatesToClients();
        return result;
    }

    public int drainHoney(int amount) {
        FluidStack fluid = this.tank.drain(amount, true);
        this.sendUpdatesToClients();
        return fluid == null ? 0 : fluid.amount;
    }

    public FluidStack getHoney() {
        if (this.tank.getFluid() == null) {
            this.tank.setFluid(new FluidStack(ModFluids.honey, 0));
        }
        return this.tank.getFluid();
    }

    private void sendUpdatesToClients() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        PacketPipeline.sendToAll(this.getPacket());
    }

    public void setOwner(String name) {
        this.owner = name;
        if (!this.field_145850_b.field_72995_K) {
            PacketPipeline.sendToAll(this.getPacket());
        }
    }

    public String getOwnerName() {
        return this.owner;
    }

    public AbstractPacket getPacket() {
        return new PacketJarOHoney(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tank.getFluid(), this.owner);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        if (packet.func_148853_f() == 0) {
            this.func_145839_a(nbt);
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
        this.owner = data.func_74779_i("owner");
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
        data.func_74778_a("owner", this.owner);
    }
}

