/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.ModBlocks;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityExtenderThingy
extends TileEntityBasicInventory {
    private boolean extending;
    private ForgeDirection dir = null;

    public TileEntityExtenderThingy() {
        super(6, "container.extenderThingy");
    }

    public void func_145845_h() {
        Block blockID;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.dir == null) {
            this.dir = this.getDirectionFromMetadata(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        Block extension = this.getExtension(this.dir);
        int index = this.getIndex(extension);
        if (this.extending) {
            blockID = extension;
        } else {
            blockID = null;
            --index;
        }
        int x = this.field_145851_c + index * this.dir.offsetX;
        int y = this.field_145848_d + index * this.dir.offsetY;
        int z = this.field_145849_e + index * this.dir.offsetZ;
        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e) {
            return;
        }
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if ((block == null || block.isReplaceable((IBlockAccess)this.field_145850_b, x, y, z) || !this.extending) && this.decreaseInventory(blockID) && this.addToInventory(x, y, z)) {
            if (this.extending) {
                this.field_145850_b.func_147465_d(x, y, z, blockID, this.getMetaFromDirection(this.dir), 3);
                this.field_145850_b.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), extension.field_149762_H.func_150495_a(), (extension.field_149762_H.func_150497_c() + 1.0f) / 2.0f, extension.field_149762_H.func_150494_d() * 0.8f);
            } else {
                this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, this.getMetaFromDirection(this.dir), 3);
                this.field_145850_b.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)extension) + (this.field_145850_b.func_72805_g(x, y, z) << 12));
            }
        }
    }

    private int getIndex(Block extension) {
        int index = 1;
        int x = this.field_145851_c + index * this.dir.offsetX;
        int y = this.field_145848_d + index * this.dir.offsetY;
        int z = this.field_145849_e + index * this.dir.offsetZ;
        while (this.field_145850_b.func_147439_a(x, y, z) == extension) {
            x = this.field_145851_c + ++index * this.dir.offsetX;
            y = this.field_145848_d + index * this.dir.offsetY;
            z = this.field_145849_e + index * this.dir.offsetZ;
        }
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block == null || block.isReplaceable((IBlockAccess)this.field_145850_b, x, y, z) || !this.extending) {
            return index;
        }
        return index - 1;
    }

    private boolean addToInventory(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (this.field_145850_b.func_147437_c(x, y, z) || block.isReplaceable((IBlockAccess)this.field_145850_b, x, y, z)) {
            return true;
        }
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) {
                this.inventory[i] = new ItemStack(block, 1, 0);
                return true;
            }
            if (this.inventory[i].func_77973_b() != Item.func_150898_a((Block)block) || this.inventory[i].field_77994_a >= this.inventory[i].func_77976_d() || this.inventory[i].field_77994_a >= this.func_70297_j_()) continue;
            ++this.inventory[i].field_77994_a;
            return true;
        }
        return false;
    }

    private boolean decreaseInventory(Block blockID) {
        if (blockID == null) {
            return true;
        }
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null || this.inventory[i].func_77973_b() != Item.func_150898_a((Block)blockID)) continue;
            --this.inventory[i].field_77994_a;
            if (this.inventory[i].field_77994_a <= 0) {
                this.inventory[i] = null;
            }
            return true;
        }
        return false;
    }

    private Block getExtension(ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN ? ModBlocks.bambooPole : ModBlocks.bambooBridge;
    }

    private int getMetaFromDirection(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return 1;
            }
            case DOWN: {
                return 1;
            }
            case EAST: 
            case WEST: {
                return 4;
            }
            case NORTH: 
            case SOUTH: {
                return 3;
            }
        }
        return 0;
    }

    private ForgeDirection getDirectionFromMetadata(int meta) {
        switch (meta) {
            case 0: {
                return ForgeDirection.DOWN;
            }
            case 1: {
                return ForgeDirection.UP;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return null;
    }

    public void setExtending(boolean extending) {
        this.extending = extending;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.bambooPole) || stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.bambooBridge));
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("extending", this.extending);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.extending = data.func_74767_n("extending");
    }
}

